/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.RouterPrx;
import IceInternal.Instance;
import IceUtil.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class ObjectAdapterFactory {
    private Instance _instance;
    private Communicator _communicator;
    private Hashtable _adapters = new Hashtable();
    private boolean _waitForShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ObjectAdapter[] objectAdapterArray = null;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            if (this._instance == null) {
                return;
            }
            objectAdapterArray = new ObjectAdapter[this._adapters.size()];
            int n = 0;
            Enumeration enumeration = this._adapters.elements();
            while (enumeration.hasMoreElements()) {
                objectAdapterArray[n++] = (ObjectAdapter)enumeration.nextElement();
            }
            this._instance = null;
            this._communicator = null;
            this.notifyAll();
        }
        for (int i = 0; i < objectAdapterArray.length; ++i) {
            objectAdapterArray[i].deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForShutdown() {
        Object object = this;
        synchronized (object) {
            while (this._instance != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            while (this._waitForShutdown) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this._waitForShutdown = true;
        }
        if (this._adapters != null) {
            object = this._adapters.elements();
            while (object.hasMoreElements()) {
                ObjectAdapter objectAdapter = (ObjectAdapter)object.nextElement();
                objectAdapter.waitForDeactivate();
            }
        }
        object = this;
        synchronized (object) {
            this._waitForShutdown = false;
            this.notifyAll();
        }
    }

    public synchronized boolean isShutdown() {
        return this._instance == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ObjectAdapter[] objectAdapterArray;
        this.waitForShutdown();
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            objectAdapterArray = new ObjectAdapter[this._adapters.size()];
            int n = 0;
            Enumeration enumeration = this._adapters.elements();
            while (enumeration.hasMoreElements()) {
                objectAdapterArray[n] = (ObjectAdapter)enumeration.nextElement();
                ++n;
            }
            this._adapters = null;
        }
        for (int i = 0; i < objectAdapterArray.length; ++i) {
            objectAdapterArray[i].destroy();
        }
    }

    public synchronized ObjectAdapter createObjectAdapter(String string, String string2, RouterPrx routerPrx) {
        if (this._instance == null) {
            throw new ObjectAdapterDeactivatedException();
        }
        ObjectAdapter objectAdapter = (ObjectAdapter)this._adapters.get(string);
        if (objectAdapter != null) {
            throw new AlreadyRegisteredException("object adapter", string);
        }
        objectAdapter = new ObjectAdapter(this._instance, this._communicator, this, string, string2, routerPrx);
        this._adapters.put(string, objectAdapter);
        return objectAdapter;
    }

    public synchronized void removeObjectAdapter(String string) {
        if (this._waitForShutdown || this._adapters == null) {
            return;
        }
        this._adapters.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        Vector vector = new Vector();
        Object object = this;
        synchronized (object) {
            Enumeration enumeration = this._adapters.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            ((ObjectAdapter)object.nextElement()).flushBatchRequests();
        }
    }

    ObjectAdapterFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
        this._waitForShutdown = false;
    }

    protected synchronized void finalize() throws Throwable {
        Debug.FinalizerAssert(this._instance == null);
        Debug.FinalizerAssert(this._communicator == null);
        Debug.FinalizerAssert(this._adapters == null);
        Debug.FinalizerAssert(!this._waitForShutdown);
    }
}

