/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrependIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class NamespaceIterator
implements AxisIterator {
    private NodeInfo element;
    private NodeTest test;
    private int index;
    private int position;
    private NamespaceNodeImpl next;
    private NamespaceNodeImpl current;
    private IntIterator nsIterator;
    private static int[] XML_NAMESPACE_CODE_ARRAY = new int[]{65537};

    public static AxisIterator makeIterator(NodeInfo element, NodeTest test) {
        boolean first = true;
        if (test instanceof AnyNodeTest || test == NodeKindTest.NAMESPACE) {
            test = null;
        }
        NamespaceIterator result = null;
        IntHashSet declared = null;
        IntHashSet undeclared = null;
        int[] buffer = new int[8];
        for (NodeInfo node = element; node != null && node.getNodeKind() == 1; node = node.getParent()) {
            int[] nslist = node.getDeclaredNamespaces(buffer);
            if (nslist == null) continue;
            for (int i = 0; i < nslist.length && nslist[i] != -1; ++i) {
                if (first) {
                    NamespaceIterator nsi = new NamespaceIterator();
                    nsi.element = element;
                    nsi.test = test;
                    nsi.index = -1;
                    undeclared = new IntHashSet(8);
                    declared = new IntHashSet(8);
                    declared.add(65537);
                    first = false;
                    result = nsi;
                }
                short uriCode = (short)(nslist[i] & 0xFFFF);
                short prefixCode = (short)(nslist[i] >> 16);
                if (uriCode == 0) {
                    undeclared.add(prefixCode);
                    continue;
                }
                if (undeclared.contains(prefixCode)) continue;
                declared.add(nslist[i]);
                undeclared.add(prefixCode);
            }
        }
        if (result == null) {
            NamespaceNodeImpl ns = new NamespaceNodeImpl(element, 65537, 0);
            if (test == null) {
                return SingleNodeIterator.makeIterator(ns);
            }
            return Navigator.filteredSingleton(ns, test);
        }
        ((NamespaceIterator)result).nsIterator = declared.iterator();
        return result;
    }

    private NamespaceIterator() {
    }

    public void advance() {
        while (this.nsIterator.hasNext()) {
            int nscode = this.nsIterator.next();
            this.next = new NamespaceNodeImpl(this.element, nscode, ++this.index);
            if (this.test != null && !this.test.matches(this.next)) continue;
            return;
        }
        this.next = null;
    }

    public boolean moveNext() {
        return this.next() != null;
    }

    public Item next() {
        if (this.index == -1) {
            this.advance();
            this.index = 0;
        }
        this.current = this.next;
        if (this.current == null) {
            this.position = -1;
            return null;
        }
        this.advance();
        ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public AxisIterator iterateAxis(byte axis, NodeTest test) {
        return this.current.iterateAxis(axis, test);
    }

    public Value atomize() throws XPathException {
        return this.current.atomize();
    }

    public CharSequence getStringValue() {
        return this.current.getStringValueCS();
    }

    public SequenceIterator getAnother() {
        return NamespaceIterator.makeIterator(this.element, this.test);
    }

    public int getProperties() {
        return 0;
    }

    public static int[] getInScopeNamespaceCodes(NodeInfo element) {
        int i;
        boolean first = true;
        IntHashSet declared = null;
        IntHashSet undeclared = null;
        int[] buffer = new int[8];
        for (NodeInfo node = element; node != null && node.getNodeKind() == 1; node = node.getParent()) {
            int[] nslist = node.getDeclaredNamespaces(buffer);
            if (nslist == null) continue;
            for (i = 0; i < nslist.length && nslist[i] != -1; ++i) {
                if (first) {
                    undeclared = new IntHashSet(8);
                    declared = new IntHashSet(8);
                    declared.add(65537);
                    first = false;
                }
                short uriCode = (short)(nslist[i] & 0xFFFF);
                short prefixCode = (short)(nslist[i] >> 16);
                if (uriCode == 0) {
                    undeclared.add(prefixCode);
                    continue;
                }
                if (undeclared.contains(prefixCode)) continue;
                declared.add(nslist[i]);
                undeclared.add(prefixCode);
            }
        }
        if (first) {
            return XML_NAMESPACE_CODE_ARRAY;
        }
        int[] codes = new int[declared.size()];
        i = 0;
        IntIterator ii = declared.iterator();
        while (ii.hasNext()) {
            codes[i++] = ii.next();
        }
        return codes;
    }

    public static class NamespaceNodeImpl
    implements NodeInfo,
    FingerprintedNode {
        NodeInfo element;
        int nscode;
        int position;
        int namecode;

        public NamespaceNodeImpl(NodeInfo element, int nscode, int position) {
            this.element = element;
            this.nscode = nscode;
            this.position = position;
            NamePool pool = element.getNamePool();
            String prefix = pool.getPrefixFromNamespaceCode(nscode);
            this.namecode = "".equals(prefix) ? -1 : pool.allocate("", "", prefix);
        }

        public int getNodeKind() {
            return 13;
        }

        public boolean isSameNodeInfo(NodeInfo other) {
            return other instanceof NamespaceNodeImpl && this.element.isSameNodeInfo(((NamespaceNodeImpl)other).element) && this.nscode == ((NamespaceNodeImpl)other).nscode;
        }

        public boolean equals(Object other) {
            return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
        }

        public int hashCode() {
            return ((Object)this.element).hashCode() ^ this.position << 13;
        }

        public String getSystemId() {
            return this.element.getSystemId();
        }

        public String getBaseURI() {
            return null;
        }

        public int getLineNumber() {
            return this.element.getLineNumber();
        }

        public int compareOrder(NodeInfo other) {
            if (other instanceof NamespaceNodeImpl && this.element.isSameNodeInfo(((NamespaceNodeImpl)other).element)) {
                int c = this.position - ((NamespaceNodeImpl)other).position;
                if (c == 0) {
                    return 0;
                }
                if (c < 0) {
                    return -1;
                }
                return 1;
            }
            if (this.element.isSameNodeInfo(other)) {
                return 1;
            }
            return this.element.compareOrder(other);
        }

        public String getStringValue() {
            return this.element.getNamePool().getURIFromURICode((short)(this.nscode & 0xFFFF));
        }

        public CharSequence getStringValueCS() {
            return this.getStringValue();
        }

        public int getNameCode() {
            return this.namecode;
        }

        public int getFingerprint() {
            if (this.namecode == -1) {
                return -1;
            }
            return this.namecode & 0xFFFFF;
        }

        public String getLocalPart() {
            if (this.namecode == -1) {
                return "";
            }
            return this.element.getNamePool().getLocalName(this.namecode);
        }

        public String getURI() {
            return "";
        }

        public String getDisplayName() {
            return this.getLocalPart();
        }

        public String getPrefix() {
            return "";
        }

        public Configuration getConfiguration() {
            return this.element.getConfiguration();
        }

        public NamePool getNamePool() {
            return this.element.getNamePool();
        }

        public int getTypeAnnotation() {
            return -1;
        }

        public NodeInfo getParent() {
            return this.element;
        }

        public AxisIterator iterateAxis(byte axisNumber) {
            return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
        }

        public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
            switch (axisNumber) {
                case 0: {
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 1: {
                    if (nodeTest.matches(this)) {
                        return new PrependIterator(this, this.element.iterateAxis((byte)1, nodeTest));
                    }
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 6: {
                    return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
                }
                case 9: {
                    return Navigator.filteredSingleton(this.element, nodeTest);
                }
                case 10: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
                }
                case 12: {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                case 13: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + axisNumber);
        }

        public String getAttributeValue(int fingerprint) {
            return null;
        }

        public NodeInfo getRoot() {
            return this.element.getRoot();
        }

        public DocumentInfo getDocumentRoot() {
            return this.element.getDocumentRoot();
        }

        public boolean hasChildNodes() {
            return false;
        }

        public void generateId(FastStringBuffer buffer) {
            this.element.generateId(buffer);
            buffer.append("n");
            buffer.append(Integer.toString(this.position));
        }

        public int getDocumentNumber() {
            return this.element.getDocumentNumber();
        }

        public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
            out.namespace(this.nscode, 32);
        }

        public int[] getDeclaredNamespaces(int[] buffer) {
            return null;
        }

        public void setSystemId(String systemId) {
        }

        public SequenceIterator getTypedValue() throws XPathException {
            return SingletonIterator.makeIterator(new StringValue(this.getStringValueCS()));
        }

        public Value atomize() throws XPathException {
            return new StringValue(this.getStringValueCS());
        }
    }
}

