require 'spec_helper'

describe Vim::AddonManager do

  it 'installs addons' do
    addon_manager.install addons('foo')
    target_dir.should have_file('syntax/foo.vim')
  end

  it 'installs multiple addons at once' do
    addon_manager.install addons('foo', 'bar')
    target_dir.should have_file('syntax/foo.vim')
    target_dir.should have_file('syntax/bar.vim')
  end

  it 'removes addons' do
    addon_manager.install addons('foo')
    addon_manager.remove addons('foo')
    target_dir.should_not have_file('syntax/foo.vim')
  end

  it 'fixes broken addons after they are upgraded to the new style' do
    Dir.chdir target_dir.path do
      FileUtils.mkdir_p 'syntax'
      FileUtils.ln_s '/non/existing/path', 'syntax/newstylemigrated.vim'
    end
    addon_manager.upgrade_from_legacy(registry.to_a)

    target_dir.should_not have_symlink('syntax/newstylemigrated.vim')
    target_dir.should have_file('vam/newstylemigrated/syntax/newstylemigrated.vim')
  end

  it 'disables addons' do
    addon_list = addons('foo')
    addon_manager.install(addon_list)
    addon_manager.disable(addon_list)

    output = File.readlines(override_file).map(&:strip)
    output.should include(addon_list.first.disabled_by_line)
  end

  it 're-enables addons' do
    addon_list = addons('foo')
    addon_manager.install(addon_list)
    addon_manager.disable(addon_list)
    File.exists?(override_file).should be_true

    addon_manager.enable(addon_list)
    File.exists?(override_file).should be_false
  end

end
