use super::test_deprecated_lifetime_can_compile::{
    AndThisToo, HasLifetimeParameterIfAddDeprecatedFields, SameHere,
};

#[test]
fn test_deprecated_lifetime() {
    let t = trybuild::TestCases::new();
    t.compile_fail("tests/rust_protobuf/v2/test_deprecated_lifetime_must_compile_error.rs");
}

#[test]
fn test_add_deprecated_lifetime() {
    // As long as compilation succeeds, we know that these fields must have had
    // lifetimes autogenerated for them, which is expected behaviour since
    // `generate.sh` should call pb-rs with the `add-deprecated-fields` option
    // on `test_deprecated_lifetime_can_compile.proto` for use in this test
    struct Thing<'a> {
        field_1: HasLifetimeParameterIfAddDeprecatedFields<'a>,
        field_2: SameHere<'a>,
        field_3: AndThisToo<'a>,
    }
}
