#
# PySNMP MIB module VDSL-LINE-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/VDSL-LINE-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:32:42 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, OctetString, Integer, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "OctetString", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueSizeConstraint, SingleValueConstraint, ConstraintsUnion, ValueRangeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "SingleValueConstraint", "ConstraintsUnion", "ValueRangeConstraint", "ConstraintsIntersection")
( HCPerfTimeElapsed, HCPerfIntervalThreshold, HCPerfIntervalCount, HCPerfCurrentCount, HCPerfInvalidIntervals, HCPerfValidIntervals, ) = mibBuilder.importSymbols("HC-PerfHist-TC-MIB", "HCPerfTimeElapsed", "HCPerfIntervalThreshold", "HCPerfIntervalCount", "HCPerfCurrentCount", "HCPerfInvalidIntervals", "HCPerfValidIntervals")
( ZeroBasedCounter64, ) = mibBuilder.importSymbols("HCNUM-TC", "ZeroBasedCounter64")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ObjectGroup, NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
( Integer32, ObjectIdentity, iso, Unsigned32, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Counter64, NotificationType, Bits, Gauge32, transmission, IpAddress, ModuleIdentity, Counter32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Integer32", "ObjectIdentity", "iso", "Unsigned32", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Counter64", "NotificationType", "Bits", "Gauge32", "transmission", "IpAddress", "ModuleIdentity", "Counter32")
( RowStatus, TextualConvention, DisplayString, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "DisplayString", "TruthValue")
vdslMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 97)).setRevisions(("2004-02-19 00:00",))
if mibBuilder.loadTexts: vdslMIB.setLastUpdated('200402190000Z')
if mibBuilder.loadTexts: vdslMIB.setOrganization('ADSLMIB Working Group')
if mibBuilder.loadTexts: vdslMIB.setContactInfo('WG-email:  adslmib@ietf.org\n          Info:      https://www1.ietf.org/mailman/listinfo/adslmib\n\n          Chair:     Mike Sneed\n                     Sand Channel Systems\n          Postal:    P.O.  Box 37324\n                     Raleigh, NC 27627-7324\n                     USA\n          Email:     sneedmike@hotmail.com\n          Phone:     +1 206 600 7022\n\n          Co-editor: Bob Ray\n                     PESA Switching Systems, Inc.\n          Postal:    330-A Wynn Drive\n                     Huntsville, AL 35805\n                     USA\n          Email:     rray@pesa.com\n          Phone:     +1 256 726 9200 ext.  142\n\n          Co-editor: Rajesh Abbi\n                     Alcatel USA\n          Postal:    2301 Sugar Bush Road\n                     Raleigh, NC 27612-3339\n                     USA\n          Email:     Rajesh.Abbi@alcatel.com\n          Phone:     +1 919 850 6194\n        ')
if mibBuilder.loadTexts: vdslMIB.setDescription('The MIB module defining objects for the management of a pair\n    of VDSL transceivers at each end of the VDSL line.  Each such\n    line has an entry in an ifTable which may include multiple\n    transceiver lines.  An agent may reside at either end of the\n    VDSL line.  However, the MIB is designed to require no\n    management communication between them beyond that inherent in\n    the low-level VDSL line protocol.  The agent may monitor and\n    control this protocol for its needs.\n\n\n\n    VDSL lines may support optional Fast or Interleaved channels.\n    If these are supported, additional entries corresponding to the\n    supported channels must be created in the ifTable.  Thus a VDSL\n    line that supports both channels will have three entries in the\n    ifTable, one for each physical, fast, and interleaved, whose\n    ifType values are equal to vdsl(97), fast(125), and\n    interleaved(124), respectively.  The ifStackTable is used to\n    represent the relationship between the entries.\n\n    Naming Conventions:\n        Vtuc -- (VTUC) transceiver at near (Central) end of line\n        Vtur -- (VTUR) transceiver at Remote end of line\n        Vtu  -- One of either Vtuc or Vtur\n        Curr -- Current\n        Prev -- Previous\n        Atn  -- Attenuation\n        ES   -- Errored Second.\n        SES  -- Severely Errored Second\n        UAS  -- Unavailable Second\n        LCS  -- Line Code Specific\n        Lof  -- Loss of Frame\n        Lol  -- Loss of Link\n        Los  -- Loss of Signal\n        Lpr  -- Loss of Power\n        xxxs -- Sum of Seconds in which xxx has occured\n                (e.g., xxx = Lof, Los, Lpr, Lol)\n        Max  -- Maximum\n        Mgn  -- Margin\n        Min  -- Minimum\n        Psd  -- Power Spectral Density\n        Snr  -- Signal to Noise Ratio\n        Tx   -- Transmit\n        Blks -- Blocks\n\n    Copyright (C) The Internet Society (2004).  This version\n    of this MIB module is part of RFC 3728: see the RFC\n    itself for full legal notices.')
vdslLineMib = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1))
vdslMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 1))
class VdslLineCodingType(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3,))
    namedValues = NamedValues(("other", 1), ("mcm", 2), ("scm", 3),)

class VdslLineEntity(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("vtuc", 1), ("vtur", 2),)

vdslLineTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1), )
if mibBuilder.loadTexts: vdslLineTable.setDescription('This table includes common attributes describing\n        both ends of the line.  It is required for all VDSL\n        physical interfaces.  VDSL physical interfaces are\n        those ifEntries where ifType is equal to vdsl(97).')
vdslLineEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: vdslLineEntry.setDescription('An entry in the vdslLineTable.')
vdslLineCoding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1, 1), VdslLineCodingType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslLineCoding.setDescription('Specifies the VDSL coding type used on this line.')
vdslLineType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("noChannel", 1), ("fastOnly", 2), ("interleavedOnly", 3), ("fastOrInterleaved", 4), ("fastAndInterleaved", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslLineType.setDescription("Defines the type of VDSL physical line entity that exists,\n        by defining whether and how the line is channelized.  If\n\n\n\n\n\n\n\n\n\n        the line is channelized,  the value will be other than\n        noChannel(1).  This object defines which channel type(s)\n        are supported.  Defined values are:\n\n        noChannel(1)          -- no channels exist\n        fastOnly(2)           -- only fast channel exists\n        interleavedOnly(3)    -- only interleaved channel exists\n        fastOrInterleaved(4)  -- either fast or interleaved channel\n                              -- exist, but only one at a time\n        fastAndInterleaved(5) -- both fast and interleaved channels\n                              -- exist\n\n        Note that 'slow' and 'interleaved' refer to the same\n        channel.  In the case that the line is channelized, the\n        manager can use the ifStackTable to determine the ifIndex\n        for the associated channel(s).")
vdslLineConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1,32)).clone('DEFVAL')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vdslLineConfProfile.setDescription('The value of this object identifies the row in the VDSL\n        Line Configuration Profile Table, vdslLineConfProfileTable,\n        which applies for this VDSL line, and channels if\n        applicable.\n\n        This object MUST be maintained in a persistent manner.')
vdslLineAlarmConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1, 4), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1,32)).clone('DEFVAL')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vdslLineAlarmConfProfile.setDescription('The value of this object identifies the row in the VDSL\n        Line Alarm Configuration Profile Table,\n        vdslLineAlarmConfProfileTable, which applies to this\n        VDSL line, and channels if applicable.\n\n        This object MUST be maintained in a persistent manner.')
vdslPhysTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2), )
if mibBuilder.loadTexts: vdslPhysTable.setDescription('This table provides one row for each Vtu.  Each row\n        contains the Physical Layer Parameters table for that\n        Vtu.  VDSL physical interfaces are those ifEntries where\n        ifType is equal to vdsl(97).')
vdslPhysEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"))
if mibBuilder.loadTexts: vdslPhysEntry.setDescription('An entry in the vdslPhysTable.')
vdslPhysSide = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 1), VdslLineEntity())
if mibBuilder.loadTexts: vdslPhysSide.setDescription('Identifies whether the transceiver is the Vtuc or Vtur.')
vdslPhysInvSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysInvSerialNumber.setDescription('The vendor specific string that identifies the\n\n\n\n        vendor equipment.')
vdslPhysInvVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysInvVendorID.setDescription('The vendor ID code is a copy of the binary vendor\n        identification field expressed as readable characters\n        in hexadecimal notation.')
vdslPhysInvVersionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 4), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysInvVersionNumber.setDescription('The vendor specific version number sent by this Vtu\n        as part of the initialization messages.  It is a copy\n        of the binary version number field expressed as\n        readable characters in hexadecimal notation.')
vdslPhysCurrSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-127,127))).setUnits('0.25dBm').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrSnrMgn.setDescription('Noise Margin as seen by this Vtu with respect to its\n        received signal in 0.25dB.  The effective range is\n        -31.75 to +31.75 dB.')
vdslPhysCurrAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 6), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('0.25dBm').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrAtn.setDescription('Measured difference in the total power transmitted by\n        the peer Vtu and the total power received by this Vtu.\n        The effective range is 0 to +63.75 dB.')
vdslPhysCurrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 7), Bits().clone(namedValues=NamedValues(("noDefect", 0), ("lossOfFraming", 1), ("lossOfSignal", 2), ("lossOfPower", 3), ("lossOfSignalQuality", 4), ("lossOfLink", 5), ("dataInitFailure", 6), ("configInitFailure", 7), ("protocolInitFailure", 8), ("noPeerVtuPresent", 9),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrStatus.setDescription("Indicates current state of the Vtu line.  This is a\n        bit-map of possible conditions.  The various bit\n        positions are:\n\n        0   noDefect             There are no defects on the line.\n\n        1   lossOfFraming        Vtu failure due to not receiving\n                                 a valid frame.\n\n        2   lossOfSignal         Vtu failure due to not receiving\n                                 signal.\n\n        3   lossOfPower          Vtu failure due to loss of power.\n\n        4   lossOfSignalQuality  Loss of Signal Quality is declared\n                                 when the Noise Margin falls below\n                                 the Minimum Noise Margin, or the\n                                 bit-error-rate exceeds 10^-7.\n\n        5   lossOfLink           Vtu failure due to inability to\n                                 link with peer Vtu.  Set whenever\n                                 the transceiver is in the 'Warm\n                                 Start' state.\n\n        6   dataInitFailure      Vtu failure during initialization\n                                 due to bit errors corrupting\n                                 startup exchange data.\n\n\n\n\n        7   configInitFailure    Vtu failure during initialization\n                                 due to peer Vtu not able to\n                                 support requested configuration.\n\n        8   protocolInitFailure  Vtu failure during initialization\n                                 due to incompatible protocol used\n                                 by the peer Vtu.\n\n        9   noPeerVtuPresent     Vtu failure during initialization\n                                 due to no activation sequence\n                                 detected from peer Vtu.\n\n        This is intended to supplement ifOperStatus.")
vdslPhysCurrOutputPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,160))).setUnits('0.1dBm').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrOutputPwr.setDescription('Measured total output power transmitted by this VTU.\n        This is the measurement that was reported during\n        the last activation sequence.')
vdslPhysCurrAttainableRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 9), Gauge32()).setUnits('kbps').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrAttainableRate.setDescription('Indicates the maximum currently attainable data rate\n        in steps of 1000 bits/second by the Vtu.  This value\n        will be equal to or greater than vdslPhysCurrLineRate.\n        Note that for SCM, the minimum and maximum data rates\n        are equal.  Note: 1 kbps = 1000 bps.')
vdslPhysCurrLineRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 10), Gauge32()).setUnits('kbps').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrLineRate.setDescription('Indicates the current data rate in steps of 1000\n        bits/second by the Vtu.  This value will be less than\n        or equal to vdslPhysCurrAttainableRate.  Note: 1 kbps =\n        1000 bps.')
vdslChanTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3), )
if mibBuilder.loadTexts: vdslChanTable.setDescription('This table provides one row for each Vtu channel.\n        VDSL channel interfaces are those ifEntries where\n        ifType is equal to interleave(124) or fast(125).')
vdslChanEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"))
if mibBuilder.loadTexts: vdslChanEntry.setDescription('An entry in the vdslChanTable.')
vdslChanInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 1), Gauge32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanInterleaveDelay.setDescription('Interleave Delay for this channel.\n\n        Interleave delay applies only to the interleave\n        (slow) channel and defines the mapping (relative\n        spacing) between subsequent input bytes at the\n\n\n\n        interleaver input and their placement in the bit\n        stream at the interleaver output.  Larger numbers\n        provide greater separation between consecutive\n        input bytes in the output bit stream allowing for\n        improved impulse noise immunity at the expense of\n        payload latency.\n\n        In the case where the ifType is fast(125), return\n        a value of zero.')
vdslChanCrcBlockLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 2), Gauge32()).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCrcBlockLength.setDescription('Indicates the length of the channel data-block\n        on which the CRC operates.')
vdslChanCurrTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 3), Gauge32()).setUnits('kbps').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurrTxRate.setDescription('Actual transmit data rate on this channel.  Note: 1\n        kbps = 1000 bps.')
vdslChanCurrTxSlowBurstProtect = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 4), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0,1275))).setUnits('microseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurrTxSlowBurstProtect.setDescription('Actual level of impulse noise (burst) protection\n        for an interleaved (slow) channel.  This parameter is\n        not applicable to fast channels.  For fast channels,\n        a value of zero shall be returned.')
vdslChanCurrTxFastFec = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 5), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0,50))).setUnits('%').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurrTxFastFec.setDescription('Actual Forward Error Correction (FEC) redundancy\n        related overhead for a fast channel.  This parameter\n        is not applicable to an interleaved (slow) channel.\n        For interleaved channels, a value of zero shall be\n        returned.')
vdslPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4), )
if mibBuilder.loadTexts: vdslPerfDataTable.setDescription('This table provides one row for each VDSL physical\n        interface.  VDSL physical interfaces are those ifEntries\n        where ifType is equal to vdsl(97).')
vdslPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"))
if mibBuilder.loadTexts: vdslPerfDataEntry.setDescription('An entry in the vdslPerfDataTable.')
vdslPerfDataValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 1), HCPerfValidIntervals()).setUnits('intervals').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataValidIntervals.setDescription('Valid Intervals per definition found in\n        HC-PerfHist-TC-MIB.')
vdslPerfDataInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 2), HCPerfInvalidIntervals()).setUnits('intervals').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataInvalidIntervals.setDescription('Invalid Intervals per definition found in\n        HC-PerfHist-TC-MIB.')
vdslPerfDataLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 3), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataLofs.setDescription('Count of seconds since the unit was last reset that there\n        was Loss of Framing.')
vdslPerfDataLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 4), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataLoss.setDescription('Count of seconds since the unit was last reset that there\n        was Loss of Signal.')
vdslPerfDataLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 5), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataLprs.setDescription('Count of seconds since the unit was last reset that there\n        was Loss of Power.')
vdslPerfDataLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 6), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataLols.setDescription('Count of seconds since the unit was last reset that there\n        was Loss of Link.')
vdslPerfDataESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 7), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataESs.setDescription('Count of Errored Seconds since the unit was last reset.\n        An Errored Second is a one-second interval containing one\n        or more CRC anomalies, or one or more LOS or LOF defects.')
vdslPerfDataSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 8), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataSESs.setDescription('Count of Severely Errored Seconds since the unit was last\n        reset.')
vdslPerfDataUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 9), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataUASs.setDescription('Count of Unavailable Seconds since the unit was last\n        reset.')
vdslPerfDataInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 10), Unsigned32()).setUnits('occurrences').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataInits.setDescription('Count of the line initialization attempts since the unit\n        was last reset.  This count includes both successful and\n        failed attempts.')
vdslPerfDataCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 11), HCPerfTimeElapsed()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinTimeElapsed.setDescription('Total elapsed seconds in this interval.')
vdslPerfDataCurr15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 12), HCPerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinLofs.setDescription('Count of seconds during this interval that there\n        was Loss of Framing.')
vdslPerfDataCurr15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 13), HCPerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinLoss.setDescription('Count of seconds during this interval that there\n        was Loss of Signal.')
vdslPerfDataCurr15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 14), HCPerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinLprs.setDescription('Count of seconds during this interval that there\n        was Loss of Power.')
vdslPerfDataCurr15MinLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 15), HCPerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinLols.setDescription('Count of seconds during this interval that there\n        was Loss of Link.')
vdslPerfDataCurr15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 16), HCPerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinESs.setDescription('Count of Errored Seconds during this interval.  An Errored\n        Second is a one-second interval containing one or more CRC\n        anomalies, or one or more LOS or LOF defects.')
vdslPerfDataCurr15MinSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 17), HCPerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinSESs.setDescription('Count of Severely Errored Seconds during this interval.')
vdslPerfDataCurr15MinUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 18), HCPerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinUASs.setDescription('Count of Unavailable Seconds during this interval.')
vdslPerfDataCurr15MinInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 19), HCPerfCurrentCount()).setUnits('occurrences').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinInits.setDescription('Count of the line initialization attempts during this\n        interval.  This count includes both successful and\n        failed attempts.')
vdslPerfData1DayValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 20), HCPerfValidIntervals()).setUnits('intervals').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfData1DayValidIntervals.setDescription('Valid Intervals per definition found in\n        HC-PerfHist-TC-MIB.')
vdslPerfData1DayInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 21), HCPerfInvalidIntervals()).setUnits('intervals').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfData1DayInvalidIntervals.setDescription('Invalid Intervals per definition found in\n        HC-PerfHist-TC-MIB.')
vdslPerfDataCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 22), HCPerfTimeElapsed()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayTimeElapsed.setDescription('Number of seconds that have elapsed since the beginning\n         of the current 1-day interval.')
vdslPerfDataCurr1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 23), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayLofs.setDescription('Count of Loss of Framing (LOF) Seconds since the\n        beginning of the current 1-day interval.')
vdslPerfDataCurr1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 24), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayLoss.setDescription('Count of Loss of Signal (LOS) Seconds since the beginning\n        of the current 1-day interval.')
vdslPerfDataCurr1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 25), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayLprs.setDescription('Count of Loss of Power (LPR) Seconds since the beginning\n        of the current 1-day interval.')
vdslPerfDataCurr1DayLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 26), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayLols.setDescription('Count of Loss of Link (LOL) Seconds since the beginning\n        of the current 1-day interval.')
vdslPerfDataCurr1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 27), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayESs.setDescription('Count of Errored Seconds (ES) since the beginning\n        of the current 1-day interval.')
vdslPerfDataCurr1DaySESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 28), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DaySESs.setDescription('Count of Severely Errored Seconds (SES) since the\n        beginning of the current 1-day interval.')
vdslPerfDataCurr1DayUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 29), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayUASs.setDescription('Count of Unavailable Seconds (UAS) since the beginning\n        of the current 1-day interval.')
vdslPerfDataCurr1DayInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 30), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayInits.setDescription('Count of the line initialization attempts since the\n        beginning of the current 1-day interval.  This count\n        includes both successful and failed attempts.')
vdslPerfIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5), )
if mibBuilder.loadTexts: vdslPerfIntervalTable.setDescription('This table provides one row for each Vtu performance\n        data collection interval.  VDSL physical interfaces are\n\n\n\n        those ifEntries where ifType is equal to vdsl(97).')
vdslPerfIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"), (0, "VDSL-LINE-MIB", "vdslPerfIntervalNumber"))
if mibBuilder.loadTexts: vdslPerfIntervalEntry.setDescription('An entry in the vdslPerfIntervalTable.')
vdslPerfIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,96)))
if mibBuilder.loadTexts: vdslPerfIntervalNumber.setDescription('Performance Data Interval number 1 is the most recent\n        previous interval; interval 96 is 24 hours ago.\n        Intervals 2 to 96 are optional.')
vdslPerfIntervalLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 2), HCPerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalLofs.setDescription('Count of seconds in the interval when there was Loss\n        of Framing.')
vdslPerfIntervalLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 3), HCPerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalLoss.setDescription('Count of seconds in the interval when there was Loss\n        of Signal.')
vdslPerfIntervalLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 4), HCPerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalLprs.setDescription('Count of seconds in the interval when there was Loss\n        of Power.')
vdslPerfIntervalLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 5), HCPerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalLols.setDescription('Count of seconds in the interval when there was Loss\n        of Link.')
vdslPerfIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 6), HCPerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalESs.setDescription('Count of Errored Seconds (ES) in the interval.  An Errored\n        Second is a one-second interval containing one or more CRC\n        anomalies, one or more LOS or LOF defects.')
vdslPerfIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 7), HCPerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalSESs.setDescription('Count of Severely Errored Seconds in the interval.')
vdslPerfIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 8), HCPerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalUASs.setDescription('Count of Unavailable Seconds in the interval.')
vdslPerfIntervalInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 9), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalInits.setDescription('Count of the line initialization attempts during this\n        interval.  This count includes both successful and\n        failed attempts.')
vdslPerf1DayIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6), )
if mibBuilder.loadTexts: vdslPerf1DayIntervalTable.setDescription('This table provides one row for each VDSL performance\n        data collection interval.  This table contains live data\n        from equipment.  As such, it is NOT persistent.')
vdslPerf1DayIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"), (0, "VDSL-LINE-MIB", "vdslPerf1DayIntervalNumber"))
if mibBuilder.loadTexts: vdslPerf1DayIntervalEntry.setDescription('An entry in the vdslPerf1DayIntervalTable.')
vdslPerf1DayIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,30)))
if mibBuilder.loadTexts: vdslPerf1DayIntervalNumber.setDescription('History Data Interval number.  Interval 1 is the most\n        recent previous day; interval 30 is 30 days ago.  Intervals\n        2 to 30 are optional.')
vdslPerf1DayIntervalMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 2), HCPerfTimeElapsed()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalMoniSecs.setDescription('The amount of time in the 1-day interval over which the\n        performance monitoring information is actually counted.\n        This value will be the same as the interval duration except\n        in a situation where performance monitoring data could not\n        be collected for any reason.')
vdslPerf1DayIntervalLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 3), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalLofs.setDescription('Count of Loss of Frame (LOF) Seconds during the 1-day\n         interval as measured by vdslPerf1DayIntervalMoniSecs.')
vdslPerf1DayIntervalLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 4), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalLoss.setDescription('Count of Loss of Signal (LOS) Seconds during the 1-day\n         interval as measured by vdslPerf1DayIntervalMoniSecs.')
vdslPerf1DayIntervalLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 5), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalLprs.setDescription('Count of Loss of Power (LPR) Seconds during the 1-day\n         interval as measured by vdslPerf1DayIntervalMoniSecs.')
vdslPerf1DayIntervalLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 6), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalLols.setDescription('Count of Loss of Link (LOL) Seconds during the 1-day\n         interval as measured by vdslPerf1DayIntervalMoniSecs.')
vdslPerf1DayIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 7), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalESs.setDescription('Count of Errored Seconds (ES) during the 1-day\n         interval as measured by vdslPerf1DayIntervalMoniSecs.')
vdslPerf1DayIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 8), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalSESs.setDescription('Count of Severely Errored Seconds (SES) during the 1-day\n         interval as measured by vdslPerf1DayIntervalMoniSecs.')
vdslPerf1DayIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 9), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalUASs.setDescription('Count of Unavailable Seconds (UAS) during the 1-day\n         interval as measured by vdslPerf1DayIntervalMoniSecs.')
vdslPerf1DayIntervalInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 10), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalInits.setDescription('Count of the line initialization attempts during the\n        1-day interval as measured by vdslPerf1DayIntervalMoniSecs.\n        This count includes both successful and failed attempts.')
vdslChanPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7), )
if mibBuilder.loadTexts: vdslChanPerfDataTable.setDescription('This table provides one row for each Vtu channel.\n        VDSL channel interfaces are those ifEntries where\n        ifType is equal to interleave(124) or fast(125).')
vdslChanPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"))
if mibBuilder.loadTexts: vdslChanPerfDataEntry.setDescription('An entry in the vdslChanPerfDataTable.')
vdslChanValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 1), HCPerfValidIntervals()).setUnits('intervals').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanValidIntervals.setDescription('Valid Intervals per definition found in\n        HC-PerfHist-TC-MIB.')
vdslChanInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 2), HCPerfInvalidIntervals()).setUnits('intervals').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanInvalidIntervals.setDescription('Invalid Intervals per definition found in\n        HC-PerfHist-TC-MIB.')
vdslChanFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 3), ZeroBasedCounter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanFixedOctets.setDescription('Count of corrected octets since the unit was last reset.')
vdslChanBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 4), ZeroBasedCounter64()).setUnits('blocks').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanBadBlks.setDescription('Count of uncorrectable blocks since the unit was last\n        reset.')
vdslChanCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 5), HCPerfTimeElapsed()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr15MinTimeElapsed.setDescription('Total elapsed seconds in this interval.')
vdslChanCurr15MinFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 6), HCPerfCurrentCount()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr15MinFixedOctets.setDescription('Count of corrected octets in this interval.')
vdslChanCurr15MinBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 7), HCPerfCurrentCount()).setUnits('blocks').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr15MinBadBlks.setDescription('Count of uncorrectable blocks in this interval.')
vdslChan1DayValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 8), HCPerfValidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayValidIntervals.setDescription('Valid Intervals per definition found in\n        HC-PerfHist-TC-MIB.')
vdslChan1DayInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 9), HCPerfInvalidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayInvalidIntervals.setDescription('Invalid Intervals per definition found in\n        HC-PerfHist-TC-MIB.')
vdslChanCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 10), HCPerfTimeElapsed()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr1DayTimeElapsed.setDescription('Number of seconds that have elapsed since the beginning\n         of the current 1-day interval.')
vdslChanCurr1DayFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 11), HCPerfCurrentCount()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr1DayFixedOctets.setDescription('Count of corrected octets since the beginning of the\n        current 1-day interval.')
vdslChanCurr1DayBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 12), HCPerfCurrentCount()).setUnits('blocks').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr1DayBadBlks.setDescription('Count of uncorrectable blocks since the beginning of the\n        current 1-day interval.')
vdslChanIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8), )
if mibBuilder.loadTexts: vdslChanIntervalTable.setDescription('This table provides one row for each Vtu channel data\n        collection interval.  VDSL channel interfaces are those\n        ifEntries where ifType is equal to interleave(124) or\n        fast(125).')
vdslChanIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"), (0, "VDSL-LINE-MIB", "vdslChanIntervalNumber"))
if mibBuilder.loadTexts: vdslChanIntervalEntry.setDescription('An entry in the vdslChanIntervalTable.')
vdslChanIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,96)))
if mibBuilder.loadTexts: vdslChanIntervalNumber.setDescription('Performance Data Interval number 1 is the most recent\n        previous interval; interval 96 is 24 hours ago.\n        Intervals 2 to 96 are optional.')
vdslChanIntervalFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8, 1, 2), HCPerfIntervalCount()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanIntervalFixedOctets.setDescription('Count of corrected octets in this interval.')
vdslChanIntervalBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8, 1, 3), HCPerfIntervalCount()).setUnits('blocks').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanIntervalBadBlks.setDescription('Count of uncorrectable blocks in this interval.')
vdslChan1DayIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9), )
if mibBuilder.loadTexts: vdslChan1DayIntervalTable.setDescription('This table provides one row for each VDSL performance\n        data collection interval.  This table contains live data\n        from equipment.  As such, it is NOT persistent.')
vdslChan1DayIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"), (0, "VDSL-LINE-MIB", "vdslChan1DayIntervalNumber"))
if mibBuilder.loadTexts: vdslChan1DayIntervalEntry.setDescription('An entry in the vdslChan1DayIntervalTable.')
vdslChan1DayIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,30)))
if mibBuilder.loadTexts: vdslChan1DayIntervalNumber.setDescription('History Data Interval number.  Interval 1 is the most\n        recent previous day; interval 30 is 30 days ago.  Intervals\n        2 to 30 are optional.')
vdslChan1DayIntervalMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1, 2), HCPerfTimeElapsed()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayIntervalMoniSecs.setDescription('The amount of time in the 1-day interval over which the\n        performance monitoring information is actually counted.\n        This value will be the same as the interval duration except\n        in a situation where performance monitoring data could not\n        be collected for any reason.')
vdslChan1DayIntervalFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1, 3), HCPerfCurrentCount()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayIntervalFixedOctets.setDescription('Count of corrected octets in this interval.')
vdslChan1DayIntervalBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1, 4), HCPerfCurrentCount()).setUnits('blocks').setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayIntervalBadBlks.setDescription('Count of uncorrectable blocks in this interval.')
vdslLineConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11), )
if mibBuilder.loadTexts: vdslLineConfProfileTable.setDescription('This table contains information on the VDSL line\n        configuration.  One entry in this table reflects a\n        profile defined by a manager which can be used to\n        configure the VDSL line.\n\n        Entries in this table MUST be maintained in a\n        persistent manner.')
vdslLineConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1), ).setIndexNames((0, "VDSL-LINE-MIB", "vdslLineConfProfileName"))
if mibBuilder.loadTexts: vdslLineConfProfileEntry.setDescription("Each entry consists of a list of parameters that\n        represents the configuration of a VDSL line.\n\n        A default profile with an index of 'DEFVAL', will\n        always exist and its parameters will be set to vendor\n        specific values, unless otherwise specified in this\n        document.")
vdslLineConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1,32)))
if mibBuilder.loadTexts: vdslLineConfProfileName.setDescription("This object identifies a row in this table.\n\n        A default profile with an index of 'DEFVAL', will\n        always exist and its parameters will be set to vendor\n        specific values, unless otherwise specified in this\n        document.")
vdslLineConfDownRateMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("manual", 1), ("adaptAtInit", 2),)).clone('adaptAtInit')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownRateMode.setDescription('Specifies the rate selection behavior for the line\n        in the downstream direction.\n\n        manual(1)       forces the rate to the configured rate\n        adaptAtInit(2)  adapts the line based upon line quality.')
vdslLineConfUpRateMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("manual", 1), ("adaptAtInit", 2),)).clone('adaptAtInit')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpRateMode.setDescription('Specifies the rate selection behavior for the line\n        in the upstream direction.\n\n        manual(1)       forces the rate to the configured rate\n        adaptAtInit(2)  adapts the line based upon line quality.')
vdslLineConfDownMaxPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,58))).setUnits('0.25dBm').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMaxPwr.setDescription('Specifies the maximum aggregate downstream power\n        level in the range 0 to 14.5 dBm.')
vdslLineConfUpMaxPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,58))).setUnits('0.25dBm').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMaxPwr.setDescription('Specifies the maximum aggregate upstream power\n        level in the range 0 to 14.5 dBm.')
vdslLineConfDownMaxSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,127))).setUnits('0.25dBm').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMaxSnrMgn.setDescription('Specifies the maximum downstream Signal/Noise Margin\n        in units of 0.25 dB, for a range of 0 to 31.75 dB.')
vdslLineConfDownMinSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,127))).setUnits('0.25dBm').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMinSnrMgn.setDescription('Specifies the minimum downstream Signal/Noise Margin\n        in units of 0.25 dB, for a range of 0 to 31.75 dB.')
vdslLineConfDownTargetSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,127))).setUnits('0.25dBm').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownTargetSnrMgn.setDescription('Specifies the target downstream Signal/Noise Margin\n        in units of 0.25 dB, for a range of 0 to 31.75 dB.\n        This is the Noise Margin the transceivers must achieve\n        with a BER of 10^-7 or better to successfully complete\n        initialization.')
vdslLineConfUpMaxSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 9), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,127))).setUnits('0.25dBm').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMaxSnrMgn.setDescription('Specifies the maximum upstream Signal/Noise Margin\n        in units of 0.25 dB, for a range of 0 to 31.75 dB.')
vdslLineConfUpMinSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,127))).setUnits('0.25dBm').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMinSnrMgn.setDescription('Specifies the minimum upstream Signal/Noise Margin\n        in units of 0.25 dB, for a range of 0 to 31.75 dB.')
vdslLineConfUpTargetSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,127))).setUnits('0.25dBm').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpTargetSnrMgn.setDescription('Specifies the target upstream Signal/Noise Margin in\n        units of 0.25 dB, for a range of 0 to 31.75 dB.  This\n        is the Noise Margin the transceivers must achieve with\n        a BER of 10^-7 or better to successfully complete\n        initialization.')
vdslLineConfDownFastMaxDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 12), Unsigned32()).setUnits('kbps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownFastMaxDataRate.setDescription('Specifies the maximum downstream fast channel\n        data rate in steps of 1000 bits/second.')
vdslLineConfDownFastMinDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 13), Unsigned32()).setUnits('kbps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownFastMinDataRate.setDescription('Specifies the minimum downstream fast channel\n        data rate in steps of 1000 bits/second.')
vdslLineConfDownSlowMaxDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 14), Unsigned32()).setUnits('kbps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownSlowMaxDataRate.setDescription('Specifies the maximum downstream slow channel\n        data rate in steps of 1000 bits/second.\n\n        The maximum aggregate downstream transmit speed\n        of the line can be derived from the sum of maximum\n        downstream fast and slow channel data rates.')
vdslLineConfDownSlowMinDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 15), Unsigned32()).setUnits('kbps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownSlowMinDataRate.setDescription('Specifies the minimum downstream slow channel\n        data rate in steps of 1000 bits/second.\n\n        The minimum aggregate downstream transmit speed\n        of the line can be derived from the sum of minimum\n        downstream fast and slow channel data rates.')
vdslLineConfUpFastMaxDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 16), Unsigned32()).setUnits('kbps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpFastMaxDataRate.setDescription('Specifies the maximum upstream fast channel\n        data rate in steps of 1000 bits/second.\n\n        The maximum aggregate upstream transmit speed\n        of the line can be derived from the sum of maximum\n        upstream fast and slow channel data rates.')
vdslLineConfUpFastMinDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 17), Unsigned32()).setUnits('kbps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpFastMinDataRate.setDescription('Specifies the minimum upstream fast channel\n        data rate in steps of 1000 bits/second.\n\n\n\n        The minimum aggregate upstream transmit speed\n        of the line can be derived from the sum of minimum\n        upstream fast and slow channel data rates.')
vdslLineConfUpSlowMaxDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 18), Unsigned32()).setUnits('kbps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpSlowMaxDataRate.setDescription('Specifies the maximum upstream slow channel\n        data rate in steps of 1000 bits/second.')
vdslLineConfUpSlowMinDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 19), Unsigned32()).setUnits('kbps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpSlowMinDataRate.setDescription('Specifies the minimum upstream slow channel\n        data rate in steps of 1000 bits/second.')
vdslLineConfDownRateRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 20), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,100))).setUnits('percent').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownRateRatio.setDescription('For dynamic rate adaptation at startup, the allocation\n        of data rate in excess of the minimum data rate for each\n        channel is controlled by the object.  This object specifies\n        the ratio of the allocation of the excess data rate between\n        the fast and the slow channels.  This allocation represents\n        downstream Fast Channel Allocation / Slow Channel\n        Allocation.')
vdslLineConfUpRateRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 21), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,100))).setUnits('percent').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpRateRatio.setDescription('For dynamic rate adaptation at startup, the allocation\n        of data rate in excess of the minimum data rate for each\n        channel is controlled by the object.  This object specifies\n        the ratio of the allocation of the excess data rate between\n        the fast and the slow channels.  This allocation represents\n        upstream Fast Channel Allocation/Slow Channel Allocation.')
vdslLineConfDownMaxInterDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 22), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMaxInterDelay.setDescription('Specifies the maximum interleave delay for the\n        downstream slow channel.')
vdslLineConfUpMaxInterDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 23), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMaxInterDelay.setDescription('Specifies the maximum interleave delay for the\n        upstream slow channel.')
vdslLineConfDownPboControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 24), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("disabled", 1), ("auto", 2), ("manual", 3),)).clone('disabled')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownPboControl.setDescription('Downstream power backoff (PBO) control for this\n        line.  For transceivers which do not support downstream\n        PBO control, this object MUST be fixed at disabled(1).\n        If auto(2) is selected, the transceiver will automatically\n        adjust the power backoff.  If manual(3) is selected,\n\n\n\n        then the transceiver will use the value from\n        vdslLineConfDownPboLevel.')
vdslLineConfUpPboControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 25), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("disabled", 1), ("auto", 2), ("manual", 3),)).clone('disabled')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpPboControl.setDescription('Upstream power backoff (PBO) control for this\n        line.  For transceivers which do not support upstream\n        PBO control, this object MUST be fixed at disabled(1).\n        If auto(2) is selected, the transceiver will automatically\n        adjust the power backoff.  If manual(3) is selected,\n        then the transceiver will use the value from\n        vdslLineConfUpPboLevel.')
vdslLineConfDownPboLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 26), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,160))).setUnits('0.25dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownPboLevel.setDescription('Specifies the downstream backoff level to be used\n        when vdslLineConfDownPboControl = manual(3).')
vdslLineConfUpPboLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 27), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,160))).setUnits('0.25dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpPboLevel.setDescription('Specifies the upstream backoff level to be used\n        when vdslLineConfUpPboControl = manual(3).')
vdslLineConfDeploymentScenario = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 28), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("fttCab", 1), ("fttEx", 2), ("other", 3),)).clone('fttCab')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDeploymentScenario.setDescription('The VDSL line deployment scenario.  When using\n        fttCab(1), the VTU-C is located in a street cabinet.\n        When using fttEx(2), the VTU-C is located at the\n        central office.  Changes to this value will have\n        no effect on the transceiver.')
vdslLineConfAdslPresence = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 29), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("none", 1), ("adslOverPots", 2), ("adslOverISDN", 3),)).clone('none')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfAdslPresence.setDescription('Indicates presence of ADSL service in the associated\n        cable bundle/binder.\n\n        none(1)         indicates no ADSL service in the bundle\n        adslOverPots(2) indicates ADSL service over POTS is\n                        present in the bundle\n        adslOverISDN(3) indicates ADSL service over ISDN is\n                        present in the bundle')
vdslLineConfApplicableStandard = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 30), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("ansi", 1), ("etsi", 2), ("itu", 3), ("other", 4),)).clone('ansi')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfApplicableStandard.setDescription('The VDSL standard to be used for the line.\n\n         ansi(1)      indicates ANSI standard\n         etsi(2)      indicates ETSI standard\n         itu(3)       indicates ITU standard\n         other(4)     indicates a standard other than the above.')
vdslLineConfBandPlan = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 31), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("bandPlan997", 1), ("bandPlan998", 2), ("bandPlanFx", 3), ("other", 4),)).clone('bandPlan997')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfBandPlan.setDescription('The VDSL band plan to be used for the line.\n\n         bandPlan997(1) is to be used for\n              ITU-T G.993.1 Bandplan-B\n              ETSI Bandplan\n              ANSI Plan 997\n\n         bandPlan998(2) is to be used for\n              ITU-T G.993.1 Bandplan-A\n              ANSI Plan 998\n\n         bandPlanFx(3) is to be used for\n              ITU-T G.993.1 Bandplan-C.\n\n         other(4) is to be used for\n              non-standard bandplans.\n\n         If this object is set to bandPlanFx(3), then the\n         object vdslLineConfBandPlanFx MUST also be set.')
vdslLineConfBandPlanFx = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 32), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(3750,12000)).clone(3750)).setUnits('kHz').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfBandPlanFx.setDescription('The frequency limit between bands D2 and U2 when\n        vdslLineConfBandPlan is set to bandPlanFx(3).')
vdslLineConfBandOptUsage = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 33), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("unused", 1), ("upstream", 2), ("downstream", 3),)).clone('unused')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfBandOptUsage.setDescription('Defines the VDSL link use of the optional frequency\n        range [25kHz - 138kHz] (Opt).\n\n        unused(1)     indicates Opt is unused\n        upstream(2)   indicates Opt usage is for upstream\n        downstream(3) indicates Opt usage is for downstream.')
vdslLineConfUpPsdTemplate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 34), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("templateMask1", 1), ("templateMask2", 2),)).clone('templateMask1')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpPsdTemplate.setDescription('The upstream PSD template to be used for the line.\n        Here, templateMask1(1) refers to a notched mask that\n        limits the transmitted PSD within the internationally\n        standardized HAM (Handheld Amateur Radio) radio bands,\n        while templateMask2(2) refers to an unnotched mask.\n\n        The masks themselves depend upon the applicable\n        standard being used (vdslLineConfApplicableStandard).')
vdslLineConfDownPsdTemplate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 35), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("templateMask1", 1), ("templateMask2", 2),)).clone('templateMask1')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownPsdTemplate.setDescription('The downstream PSD template to be used for the line.\n        Here, templateMask1(1) refers to a notched mask that\n        limits the transmitted PSD within the internationally\n        standardized HAM (Handheld Amateur Radio) radio bands,\n        while templateMask2(2) refers to an unnotched mask.\n\n        The masks themselves depend upon the applicable\n        standard being used (vdslLineConfApplicableStandard).')
vdslLineConfHamBandMask = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 36), Bits().clone(namedValues=NamedValues(("customNotch1", 0), ("customNotch2", 1), ("amateurBand30m", 2), ("amateurBand40m", 3), ("amateurBand80m", 4), ("amateurBand160m", 5),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfHamBandMask.setDescription('The transmit power spectral density mask code, used\n        to avoid interference with HAM (Handheld Amateur Radio)\n        radio bands by introducing power control (notching) in one\n        or more of these bands.\n\n        Amateur radio band notching is defined in the VDSL\n        spectrum as follows:\n\n        Band  Start Frequency     Stop Frequency\n        ----  ------------------  --------------------------------\n        30m   1810 kHz            2000 kHz\n        40m   3500 kHz            3800 kHz (ETSI); 4000 kHz (ANSI)\n        80m   7000 kHz            7100 kHz (ETSI); 7300 kHz (ANSI)\n        160m  10100 kHz           10150 kHz\n\n\n\n        Notching for each standard band can be enabled or disabled\n        via the bit mask.\n\n        Two custom notches may be specified.  If either of these\n        are enabled via the bit mask, then the following objects\n        MUST be specified:\n\n        If customNotch1 is enabled, then both\n            vdslLineConfCustomNotch1Start\n            vdslLineConfCustomNotch1Stop\n        MUST be specified.\n\n        If customNotch2 is enabled, then both\n            vdslLineConfCustomNotch2Start\n            vdslLineConfCustomNotch2Stop\n        MUST be specified.')
vdslLineConfCustomNotch1Start = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 37), Unsigned32()).setUnits('kHz').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfCustomNotch1Start.setDescription('Specifies the start frequency of custom HAM (Handheld\n        Amateur Radio) notch 1.  vdslLineConfCustomNotch1Start MUST\n        be less than or equal to vdslLineConfCustomNotch1Stop.')
vdslLineConfCustomNotch1Stop = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 38), Unsigned32()).setUnits('kHz').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfCustomNotch1Stop.setDescription('Specifies the stop frequency of custom HAM (Handheld\n        Amateur Radio) notch 1.  vdslLineConfCustomNotch1Stop MUST\n        be greater than or equal to vdslLineConfCustomNotch1Start.')
vdslLineConfCustomNotch2Start = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 39), Unsigned32()).setUnits('kHz').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfCustomNotch2Start.setDescription('Specifies the start frequency of custom HAM (Handheld\n        Amateur Radio) notch 2.  vdslLineConfCustomNotch2Start MUST\n        be less than or equal to vdslLineConfCustomNotch2Stop.')
vdslLineConfCustomNotch2Stop = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 40), Unsigned32()).setUnits('kHz').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfCustomNotch2Stop.setDescription('Specifies the stop frequency of custom HAM (Handheld\n        Amateur Radio) notch 2.  vdslLineConfCustomNotch2Stop MUST\n        be greater than or equal to vdslLineConfCustomNotch2Start.')
vdslLineConfDownTargetSlowBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 41), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,1275))).setUnits('microseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownTargetSlowBurst.setDescription('Specifies the target level of impulse noise (burst)\n        protection for an interleaved (slow) channel.')
vdslLineConfUpTargetSlowBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 42), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,1275))).setUnits('microseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpTargetSlowBurst.setDescription('Specifies the target level of impulse noise (burst)\n        protection for an interleaved (slow) channel.')
vdslLineConfDownMaxFastFec = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 43), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,50))).setUnits('%').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMaxFastFec.setDescription('This parameter provisions the maximum level of Forward\n        Error Correction (FEC) redundancy related overhead to\n        be maintained for a fast channel.')
vdslLineConfUpMaxFastFec = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 44), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,50))).setUnits('%').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMaxFastFec.setDescription('This parameter provisions the maximum level of Forward\n        Error Correction (FEC) redundancy related overhead to\n        be maintained for a fast channel.')
vdslLineConfLineType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 45), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("noChannel", 1), ("fastOnly", 2), ("interleavedOnly", 3), ("fastOrInterleaved", 4), ("fastAndInterleaved", 5),)).clone('noChannel')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfLineType.setDescription("This parameter provisions the VDSL physical entity at\n        start-up by defining whether and how the line will be\n        channelized, i.e., which channel type(s) are supported.\n        If the line is to be channelized, the value will be other\n        than noChannel(1).\n\n        This configuration can be activated only during start-up.\n        Afterwards, the value of vdslLineType coincides with the\n        value of vdslLineConfLineType.  Depending on this value,\n        the corresponding entries in the ifTable for the\n        interleaved and the fast channels are enabled or disabled\n        according to the value of their ifOperStatus.\n\n        Defined values are:\n\n\n\n        noChannel(1)          -- no channels exist\n        fastOnly(2)           -- only fast channel exists\n        interleavedOnly(3)    -- only interleaved channel exists\n        fastOrInterleaved(4)  -- either fast or interleaved channel\n                              -- exists, but only one at a time\n        fastAndInterleaved(5) -- both fast and interleaved channels\n                              -- exist\n\n        Note that 'slow' and 'interleaved' refer to the same\n        channel.")
vdslLineConfProfRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 46), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfProfRowStatus.setDescription("This object is used to create a new row or modify or\n        delete an existing row in this table.\n\n        A profile activated by setting this object to 'active'.\n        When 'active' is set, the system will validate the profile.\n\n        Before a profile can be deleted or taken out of service\n        (by setting this object to 'destroy' or 'outOfService'),\n        it must be first unreferenced from all associated lines.\n\n        An 'active' profile may be modified at any time.  Note\n        that some changes may require that any referenced lines be\n        restarted (e.g., vdslLineConfLineType).")
vdslLineAlarmConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20), )
if mibBuilder.loadTexts: vdslLineAlarmConfProfileTable.setDescription('This table contains information on the VDSL line alarm\n        configuration.  One entry in this table reflects a profile\n        defined by a manager which can be used to configure the\n        VDSL line alarm thresholds.\n\n\n\n\n        Entries in this table MUST be maintained in a\n        persistent manner.')
vdslLineAlarmConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1), ).setIndexNames((0, "VDSL-LINE-MIB", "vdslLineAlarmConfProfileName"))
if mibBuilder.loadTexts: vdslLineAlarmConfProfileEntry.setDescription("Each entry consists of a list of parameters that\n        represents the configuration of a VDSL line alarm\n        profile.\n\n        A default profile with an index of 'DEFVAL', will\n        always exist and its parameters will be set to vendor\n        specific values, unless otherwise specified in this\n        document.")
vdslLineAlarmConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1,32)))
if mibBuilder.loadTexts: vdslLineAlarmConfProfileName.setDescription('The name for this profile as specified by an\n        administrator.')
vdslLineAlarmConfThresh15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 2), HCPerfIntervalThreshold()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinLofs.setDescription('This object configures the threshold for the number of\n         loss of frame seconds (lofs) within any given 15-minute\n         performance data collection interval.  If the value of\n         loss of frame seconds in a particular 15-minute collection\n         interval reaches/exceeds this value, a\n         vdslPerfLofsThreshNotification notification will be\n         generated.  No more than one notification will be sent\n         per interval.')
vdslLineAlarmConfThresh15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 3), HCPerfIntervalThreshold()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinLoss.setDescription('This object configures the threshold for the number of\n         loss of signal seconds (loss) within any given 15-minute\n         performance data collection interval.  If the value of\n         loss of signal seconds in a particular 15-minute\n         collection interval reaches/exceeds this value, a\n         vdslPerfLossThreshNotification notification will be\n         generated.  One notification will be sent per interval\n         per endpoint.')
vdslLineAlarmConfThresh15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 4), HCPerfIntervalThreshold()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinLprs.setDescription('This object configures the threshold for the number of\n         loss of power seconds (lprs) within any given 15-minute\n         performance data collection interval.  If the value of\n         loss of power seconds in a particular 15-minute collection\n         interval reaches/exceeds this value, a\n         vdslPerfLprsThreshNotification notification will be\n         generated.  No more than one notification will be sent\n         per interval.')
vdslLineAlarmConfThresh15MinLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 5), HCPerfIntervalThreshold()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinLols.setDescription('This object configures the threshold for the number of\n         loss of link seconds (lols) within any given 15-minute\n         performance data collection interval.  If the value of\n         loss of power seconds in a particular 15-minute collection\n         interval reaches/exceeds this value, a\n         vdslPerfLolsThreshNotification notification will be\n         generated.  No more than one notification will be sent\n         per interval.')
vdslLineAlarmConfThresh15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 6), HCPerfIntervalThreshold()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinESs.setDescription('This object configures the threshold for the number of\n         errored seconds (ESs) within any given 15-minute\n         performance data collection interval.  If the value of\n         errored seconds in a particular 15-minute collection\n         interval reaches/exceeds this value, a\n         vdslPerfESsThreshNotification notification will be\n         generated.  No more than one notification will be sent\n         per interval.')
vdslLineAlarmConfThresh15MinSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 7), HCPerfIntervalThreshold()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinSESs.setDescription('This object configures the threshold for the number of\n         severely errored seconds (SESs) within any given 15-minute\n         performance data collection interval.  If the value of\n         severely errored seconds in a particular 15-minute\n         collection interval reaches/exceeds this value, a\n         vdslPerfSESsThreshNotification notification will be\n         generated.  No more than one notification will be sent\n         per interval.')
vdslLineAlarmConfThresh15MinUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 8), HCPerfIntervalThreshold()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinUASs.setDescription('This object configures the threshold for the number of\n         unavailable seconds (UASs) within any given 15-minute\n         performance data collection interval.  If the value of\n         unavailable seconds in a particular 15-minute collection\n         interval reaches/exceeds this value, a\n         vdslPerfUASsThreshNotification notification will be\n         generated.  No more than one notification will be sent\n         per interval.')
vdslLineAlarmConfInitFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 9), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfInitFailure.setDescription('This object specifies if a vdslInitFailureNotification\n        notification will be generated if an initialization\n        failure occurs.')
vdslLineAlarmConfProfRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfProfRowStatus.setDescription("This object is used to create a new row or modify or\n        delete an existing row in this table.\n\n        A profile activated by setting this object to 'active'.\n        When 'active' is set, the system will validate the profile.\n\n        Before a profile can be deleted or taken out of service,\n        (by setting this object to 'destroy' or 'outOfService') it\n        must be first unreferenced from all associated lines.\n\n        An 'active' profile may be modified at any time.")
vdslNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 0))
vdslPerfLofsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 1)).setObjects(*(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLofs"),))
if mibBuilder.loadTexts: vdslPerfLofsThreshNotification.setDescription('Loss of Framing 15-minute interval threshold\n         (vdslLineAlarmConfThresh15MinLofs) reached.')
vdslPerfLossThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 2)).setObjects(*(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLoss"),))
if mibBuilder.loadTexts: vdslPerfLossThreshNotification.setDescription('Loss of Signal 15-minute interval threshold\n        (vdslLineAlarmConfThresh15MinLoss) reached.')
vdslPerfLprsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 3)).setObjects(*(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLprs"),))
if mibBuilder.loadTexts: vdslPerfLprsThreshNotification.setDescription('Loss of Power 15-minute interval threshold\n        (vdslLineAlarmConfThresh15MinLprs) reached.')
vdslPerfLolsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 4)).setObjects(*(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLols"),))
if mibBuilder.loadTexts: vdslPerfLolsThreshNotification.setDescription('Loss of Link 15-minute interval threshold\n        (vdslLineAlarmConfThresh15MinLols) reached.')
vdslPerfESsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 5)).setObjects(*(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinESs"),))
if mibBuilder.loadTexts: vdslPerfESsThreshNotification.setDescription('Errored Seconds 15-minute interval threshold\n        (vdslLineAlarmConfThresh15MinESs) reached.')
vdslPerfSESsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 6)).setObjects(*(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinSESs"),))
if mibBuilder.loadTexts: vdslPerfSESsThreshNotification.setDescription('Severely Errored Seconds 15-minute interval threshold\n        (vdslLineAlarmConfThresh15MinSESs) reached.')
vdslPerfUASsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 7)).setObjects(*(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinUASs"),))
if mibBuilder.loadTexts: vdslPerfUASsThreshNotification.setDescription('Unavailable Seconds 15-minute interval threshold\n        (vdslLineAlarmConfThresh15MinUASs) reached.')
vdslDownMaxSnrMgnNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 8)).setObjects(*(("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"),))
if mibBuilder.loadTexts: vdslDownMaxSnrMgnNotification.setDescription('The downstream Signal to Noise Margin exceeded\n        vdslLineConfDownMaxSnrMgn.  The object\n        vdslPhysCurrSnrMgn will contain the Signal to Noise\n        margin as measured by the VTU-R.')
vdslDownMinSnrMgnNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 9)).setObjects(*(("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"),))
if mibBuilder.loadTexts: vdslDownMinSnrMgnNotification.setDescription('The downstream Signal to Noise Margin fell below\n        vdslLineConfDownMinSnrMgn.  The object vdslPhysCurrSnrMgn\n        will contain the Signal to Noise margin as measured by\n        the VTU-R.')
vdslUpMaxSnrMgnNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 10)).setObjects(*(("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"),))
if mibBuilder.loadTexts: vdslUpMaxSnrMgnNotification.setDescription('The upstream Signal to Noise Margin exceeded\n        vdslLineConfUpMaxSnrMgn.  The object vdslPhysCurrSnrMgn\n        will contain the Signal to Noise margin as measured\n        by the VTU-C.')
vdslUpMinSnrMgnNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 11)).setObjects(*(("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"),))
if mibBuilder.loadTexts: vdslUpMinSnrMgnNotification.setDescription('The upstream Signal to Noise Margin fell below\n        vdslLineConfUpMinSnrMgn.  The object vdslPhysCurrSnrMgn\n        will contain the Signal to Noise margin as measured\n        by the VTU-C.')
vdslInitFailureNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 12)).setObjects(*(("VDSL-LINE-MIB", "vdslPhysCurrStatus"),))
if mibBuilder.loadTexts: vdslInitFailureNotification.setDescription('Vtu initialization failed.  See vdslPhysCurrStatus for\n        potential reasons.')
vdslConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 3))
vdslGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 3, 1))
vdslCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 3, 2))
vdslLineMibCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 97, 1, 3, 2, 1)).setObjects(*(("VDSL-LINE-MIB", "vdslGroup"), ("VDSL-LINE-MIB", "vdslNotificationGroup"),))
if mibBuilder.loadTexts: vdslLineMibCompliance.setDescription('The compliance statement for SNMP entities which\n        manage VDSL interfaces.')
vdslGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 97, 1, 3, 1, 1)).setObjects(*(("VDSL-LINE-MIB", "vdslLineCoding"), ("VDSL-LINE-MIB", "vdslLineType"), ("VDSL-LINE-MIB", "vdslLineConfProfile"), ("VDSL-LINE-MIB", "vdslLineAlarmConfProfile"), ("VDSL-LINE-MIB", "vdslPhysInvSerialNumber"), ("VDSL-LINE-MIB", "vdslPhysInvVendorID"), ("VDSL-LINE-MIB", "vdslPhysInvVersionNumber"), ("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"), ("VDSL-LINE-MIB", "vdslPhysCurrAtn"), ("VDSL-LINE-MIB", "vdslPhysCurrStatus"), ("VDSL-LINE-MIB", "vdslPhysCurrOutputPwr"), ("VDSL-LINE-MIB", "vdslPhysCurrAttainableRate"), ("VDSL-LINE-MIB", "vdslPhysCurrLineRate"), ("VDSL-LINE-MIB", "vdslChanInterleaveDelay"), ("VDSL-LINE-MIB", "vdslChanCrcBlockLength"), ("VDSL-LINE-MIB", "vdslChanCurrTxRate"), ("VDSL-LINE-MIB", "vdslChanCurrTxSlowBurstProtect"), ("VDSL-LINE-MIB", "vdslChanCurrTxFastFec"), ("VDSL-LINE-MIB", "vdslPerfDataValidIntervals"), ("VDSL-LINE-MIB", "vdslPerfDataInvalidIntervals"), ("VDSL-LINE-MIB", "vdslPerfDataLofs"), ("VDSL-LINE-MIB", "vdslPerfDataLoss"), ("VDSL-LINE-MIB", "vdslPerfDataLprs"), ("VDSL-LINE-MIB", "vdslPerfDataLols"), ("VDSL-LINE-MIB", "vdslPerfDataESs"), ("VDSL-LINE-MIB", "vdslPerfDataSESs"), ("VDSL-LINE-MIB", "vdslPerfDataUASs"), ("VDSL-LINE-MIB", "vdslPerfDataInits"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinTimeElapsed"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLofs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLoss"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLprs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLols"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinESs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinSESs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinUASs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinInits"), ("VDSL-LINE-MIB", "vdslPerfData1DayValidIntervals"), ("VDSL-LINE-MIB", "vdslPerfData1DayInvalidIntervals"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayTimeElapsed"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayLofs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayLoss"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayLprs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayLols"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayESs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DaySESs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayUASs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayInits"), ("VDSL-LINE-MIB", "vdslPerfIntervalLofs"), ("VDSL-LINE-MIB", "vdslPerfIntervalLoss"), ("VDSL-LINE-MIB", "vdslPerfIntervalLprs"), ("VDSL-LINE-MIB", "vdslPerfIntervalLols"), ("VDSL-LINE-MIB", "vdslPerfIntervalESs"), ("VDSL-LINE-MIB", "vdslPerfIntervalSESs"), ("VDSL-LINE-MIB", "vdslPerfIntervalUASs"), ("VDSL-LINE-MIB", "vdslPerfIntervalInits"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalMoniSecs"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalLofs"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalLoss"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalLprs"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalLols"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalESs"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalSESs"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalUASs"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalInits"), ("VDSL-LINE-MIB", "vdslChanValidIntervals"), ("VDSL-LINE-MIB", "vdslChanInvalidIntervals"), ("VDSL-LINE-MIB", "vdslChanFixedOctets"), ("VDSL-LINE-MIB", "vdslChanBadBlks"), ("VDSL-LINE-MIB", "vdslChanCurr15MinTimeElapsed"), ("VDSL-LINE-MIB", "vdslChanCurr15MinFixedOctets"), ("VDSL-LINE-MIB", "vdslChanCurr15MinBadBlks"), ("VDSL-LINE-MIB", "vdslChan1DayValidIntervals"), ("VDSL-LINE-MIB", "vdslChan1DayInvalidIntervals"), ("VDSL-LINE-MIB", "vdslChanCurr1DayTimeElapsed"), ("VDSL-LINE-MIB", "vdslChanCurr1DayFixedOctets"), ("VDSL-LINE-MIB", "vdslChanCurr1DayBadBlks"), ("VDSL-LINE-MIB", "vdslChanIntervalFixedOctets"), ("VDSL-LINE-MIB", "vdslChanIntervalBadBlks"), ("VDSL-LINE-MIB", "vdslChan1DayIntervalMoniSecs"), ("VDSL-LINE-MIB", "vdslChan1DayIntervalFixedOctets"), ("VDSL-LINE-MIB", "vdslChan1DayIntervalBadBlks"), ("VDSL-LINE-MIB", "vdslLineConfDownRateMode"), ("VDSL-LINE-MIB", "vdslLineConfUpRateMode"), ("VDSL-LINE-MIB", "vdslLineConfDownMaxPwr"), ("VDSL-LINE-MIB", "vdslLineConfUpMaxPwr"), ("VDSL-LINE-MIB", "vdslLineConfDownMaxSnrMgn"), ("VDSL-LINE-MIB", "vdslLineConfDownMinSnrMgn"), ("VDSL-LINE-MIB", "vdslLineConfDownTargetSnrMgn"), ("VDSL-LINE-MIB", "vdslLineConfUpMaxSnrMgn"), ("VDSL-LINE-MIB", "vdslLineConfUpMinSnrMgn"), ("VDSL-LINE-MIB", "vdslLineConfUpTargetSnrMgn"), ("VDSL-LINE-MIB", "vdslLineConfDownFastMaxDataRate"), ("VDSL-LINE-MIB", "vdslLineConfDownFastMinDataRate"), ("VDSL-LINE-MIB", "vdslLineConfDownSlowMaxDataRate"), ("VDSL-LINE-MIB", "vdslLineConfDownSlowMinDataRate"), ("VDSL-LINE-MIB", "vdslLineConfUpFastMaxDataRate"), ("VDSL-LINE-MIB", "vdslLineConfUpFastMinDataRate"), ("VDSL-LINE-MIB", "vdslLineConfUpSlowMaxDataRate"), ("VDSL-LINE-MIB", "vdslLineConfUpSlowMinDataRate"), ("VDSL-LINE-MIB", "vdslLineConfDownRateRatio"), ("VDSL-LINE-MIB", "vdslLineConfUpRateRatio"), ("VDSL-LINE-MIB", "vdslLineConfDownMaxInterDelay"), ("VDSL-LINE-MIB", "vdslLineConfUpMaxInterDelay"), ("VDSL-LINE-MIB", "vdslLineConfDownPboControl"), ("VDSL-LINE-MIB", "vdslLineConfUpPboControl"), ("VDSL-LINE-MIB", "vdslLineConfDownPboLevel"), ("VDSL-LINE-MIB", "vdslLineConfUpPboLevel"), ("VDSL-LINE-MIB", "vdslLineConfDeploymentScenario"), ("VDSL-LINE-MIB", "vdslLineConfAdslPresence"), ("VDSL-LINE-MIB", "vdslLineConfApplicableStandard"), ("VDSL-LINE-MIB", "vdslLineConfBandPlan"), ("VDSL-LINE-MIB", "vdslLineConfBandPlanFx"), ("VDSL-LINE-MIB", "vdslLineConfBandOptUsage"), ("VDSL-LINE-MIB", "vdslLineConfUpPsdTemplate"), ("VDSL-LINE-MIB", "vdslLineConfDownPsdTemplate"), ("VDSL-LINE-MIB", "vdslLineConfHamBandMask"), ("VDSL-LINE-MIB", "vdslLineConfCustomNotch1Start"), ("VDSL-LINE-MIB", "vdslLineConfCustomNotch1Stop"), ("VDSL-LINE-MIB", "vdslLineConfCustomNotch2Start"), ("VDSL-LINE-MIB", "vdslLineConfCustomNotch2Stop"), ("VDSL-LINE-MIB", "vdslLineConfDownTargetSlowBurst"), ("VDSL-LINE-MIB", "vdslLineConfUpTargetSlowBurst"), ("VDSL-LINE-MIB", "vdslLineConfDownMaxFastFec"), ("VDSL-LINE-MIB", "vdslLineConfUpMaxFastFec"), ("VDSL-LINE-MIB", "vdslLineConfLineType"), ("VDSL-LINE-MIB", "vdslLineConfProfRowStatus"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinLofs"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinLoss"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinLprs"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinLols"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinESs"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinSESs"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinUASs"), ("VDSL-LINE-MIB", "vdslLineAlarmConfInitFailure"), ("VDSL-LINE-MIB", "vdslLineAlarmConfProfRowStatus"),))
if mibBuilder.loadTexts: vdslGroup.setDescription('A collection of objects providing information about\n             a VDSL Line.')
vdslNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 97, 1, 3, 1, 2)).setObjects(*(("VDSL-LINE-MIB", "vdslPerfLofsThreshNotification"), ("VDSL-LINE-MIB", "vdslPerfLossThreshNotification"), ("VDSL-LINE-MIB", "vdslPerfLprsThreshNotification"), ("VDSL-LINE-MIB", "vdslPerfLolsThreshNotification"), ("VDSL-LINE-MIB", "vdslPerfESsThreshNotification"), ("VDSL-LINE-MIB", "vdslPerfSESsThreshNotification"), ("VDSL-LINE-MIB", "vdslPerfUASsThreshNotification"), ("VDSL-LINE-MIB", "vdslDownMaxSnrMgnNotification"), ("VDSL-LINE-MIB", "vdslDownMinSnrMgnNotification"), ("VDSL-LINE-MIB", "vdslUpMaxSnrMgnNotification"), ("VDSL-LINE-MIB", "vdslUpMinSnrMgnNotification"), ("VDSL-LINE-MIB", "vdslInitFailureNotification"),))
if mibBuilder.loadTexts: vdslNotificationGroup.setDescription('This group supports notifications of significant\n             conditions associated with VDSL Lines.')
mibBuilder.exportSymbols("VDSL-LINE-MIB", vdslLineConfUpMaxPwr=vdslLineConfUpMaxPwr, vdslPerfDataCurr1DayInits=vdslPerfDataCurr1DayInits, vdslDownMaxSnrMgnNotification=vdslDownMaxSnrMgnNotification, vdslChanPerfDataEntry=vdslChanPerfDataEntry, vdslLineConfDownPboLevel=vdslLineConfDownPboLevel, vdslPerfDataCurr1DayLols=vdslPerfDataCurr1DayLols, vdslLineAlarmConfProfRowStatus=vdslLineAlarmConfProfRowStatus, vdslLineConfBandPlanFx=vdslLineConfBandPlanFx, vdslLineConfProfileName=vdslLineConfProfileName, vdslPhysInvSerialNumber=vdslPhysInvSerialNumber, vdslPerfDataLprs=vdslPerfDataLprs, vdslPerfDataCurr1DayESs=vdslPerfDataCurr1DayESs, vdslPerfIntervalLofs=vdslPerfIntervalLofs, vdslChanIntervalEntry=vdslChanIntervalEntry, vdslPerfDataInits=vdslPerfDataInits, vdslLineConfUpFastMinDataRate=vdslLineConfUpFastMinDataRate, vdslLineConfAdslPresence=vdslLineConfAdslPresence, PYSNMP_MODULE_ID=vdslMIB, vdslPerfIntervalSESs=vdslPerfIntervalSESs, vdslLineConfUpMaxInterDelay=vdslLineConfUpMaxInterDelay, VdslLineCodingType=VdslLineCodingType, vdslChanCurrTxFastFec=vdslChanCurrTxFastFec, vdslPerfDataUASs=vdslPerfDataUASs, vdslChanValidIntervals=vdslChanValidIntervals, vdslLineConfDeploymentScenario=vdslLineConfDeploymentScenario, vdslLineConfCustomNotch2Start=vdslLineConfCustomNotch2Start, vdslChanEntry=vdslChanEntry, vdslDownMinSnrMgnNotification=vdslDownMinSnrMgnNotification, vdslPerf1DayIntervalLofs=vdslPerf1DayIntervalLofs, vdslChanCurr15MinBadBlks=vdslChanCurr15MinBadBlks, vdslLineAlarmConfThresh15MinLols=vdslLineAlarmConfThresh15MinLols, vdslLineMibCompliance=vdslLineMibCompliance, vdslPhysSide=vdslPhysSide, vdslPerfDataESs=vdslPerfDataESs, vdslPerfDataCurr15MinLoss=vdslPerfDataCurr15MinLoss, vdslPerfIntervalLprs=vdslPerfIntervalLprs, vdslLineConfDownFastMaxDataRate=vdslLineConfDownFastMaxDataRate, vdslLineAlarmConfThresh15MinSESs=vdslLineAlarmConfThresh15MinSESs, vdslUpMinSnrMgnNotification=vdslUpMinSnrMgnNotification, vdslChanFixedOctets=vdslChanFixedOctets, vdslLineConfLineType=vdslLineConfLineType, vdslPerf1DayIntervalTable=vdslPerf1DayIntervalTable, vdslPhysCurrSnrMgn=vdslPhysCurrSnrMgn, vdslLineConfBandPlan=vdslLineConfBandPlan, vdslLineConfUpSlowMinDataRate=vdslLineConfUpSlowMinDataRate, vdslPerfDataLoss=vdslPerfDataLoss, vdslPerfIntervalUASs=vdslPerfIntervalUASs, vdslPerfDataCurr15MinTimeElapsed=vdslPerfDataCurr15MinTimeElapsed, vdslPerfData1DayInvalidIntervals=vdslPerfData1DayInvalidIntervals, vdslPerfIntervalESs=vdslPerfIntervalESs, vdslPerf1DayIntervalUASs=vdslPerf1DayIntervalUASs, vdslLineConfDownTargetSnrMgn=vdslLineConfDownTargetSnrMgn, vdslChanIntervalTable=vdslChanIntervalTable, vdslLineConfDownTargetSlowBurst=vdslLineConfDownTargetSlowBurst, vdslPhysInvVendorID=vdslPhysInvVendorID, vdslPerf1DayIntervalNumber=vdslPerf1DayIntervalNumber, VdslLineEntity=VdslLineEntity, vdslLineConfUpMaxFastFec=vdslLineConfUpMaxFastFec, vdslPhysTable=vdslPhysTable, vdslNotifications=vdslNotifications, vdslPerf1DayIntervalLoss=vdslPerf1DayIntervalLoss, vdslChan1DayIntervalEntry=vdslChan1DayIntervalEntry, vdslPerf1DayIntervalMoniSecs=vdslPerf1DayIntervalMoniSecs, vdslChanTable=vdslChanTable, vdslPerfDataCurr15MinSESs=vdslPerfDataCurr15MinSESs, vdslLineConfProfRowStatus=vdslLineConfProfRowStatus, vdslPhysCurrStatus=vdslPhysCurrStatus, vdslPerfDataEntry=vdslPerfDataEntry, vdslChan1DayIntervalFixedOctets=vdslChan1DayIntervalFixedOctets, vdslLineConfUpTargetSnrMgn=vdslLineConfUpTargetSnrMgn, vdslLineConfDownMaxFastFec=vdslLineConfDownMaxFastFec, vdslCompliances=vdslCompliances, vdslLineConfUpPsdTemplate=vdslLineConfUpPsdTemplate, vdslLineConfProfileEntry=vdslLineConfProfileEntry, vdslPerf1DayIntervalSESs=vdslPerf1DayIntervalSESs, vdslLineConfCustomNotch2Stop=vdslLineConfCustomNotch2Stop, vdslPerfData1DayValidIntervals=vdslPerfData1DayValidIntervals, vdslChanCurrTxRate=vdslChanCurrTxRate, vdslPerfLolsThreshNotification=vdslPerfLolsThreshNotification, vdslLineConfUpPboControl=vdslLineConfUpPboControl, vdslLineConfBandOptUsage=vdslLineConfBandOptUsage, vdslLineAlarmConfProfileName=vdslLineAlarmConfProfileName, vdslUpMaxSnrMgnNotification=vdslUpMaxSnrMgnNotification, vdslPerfDataCurr15MinLofs=vdslPerfDataCurr15MinLofs, vdslLineConfUpFastMaxDataRate=vdslLineConfUpFastMaxDataRate, vdslChanInvalidIntervals=vdslChanInvalidIntervals, vdslLineCoding=vdslLineCoding, vdslPerfIntervalEntry=vdslPerfIntervalEntry, vdslPhysInvVersionNumber=vdslPhysInvVersionNumber, vdslPerfIntervalLoss=vdslPerfIntervalLoss, vdslChanCurr1DayBadBlks=vdslChanCurr1DayBadBlks, vdslConformance=vdslConformance, vdslLineType=vdslLineType, vdslLineConfDownRateMode=vdslLineConfDownRateMode, vdslLineConfDownPboControl=vdslLineConfDownPboControl, vdslLineConfDownRateRatio=vdslLineConfDownRateRatio, vdslChan1DayInvalidIntervals=vdslChan1DayInvalidIntervals, vdslChanPerfDataTable=vdslChanPerfDataTable, vdslLineAlarmConfProfileEntry=vdslLineAlarmConfProfileEntry, vdslPerfDataLofs=vdslPerfDataLofs, vdslChanIntervalNumber=vdslChanIntervalNumber, vdslPhysEntry=vdslPhysEntry, vdslMIB=vdslMIB, vdslPhysCurrAtn=vdslPhysCurrAtn, vdslPerfIntervalInits=vdslPerfIntervalInits, vdslChanIntervalFixedOctets=vdslChanIntervalFixedOctets, vdslGroups=vdslGroups, vdslPerfDataCurr15MinESs=vdslPerfDataCurr15MinESs, vdslLineAlarmConfThresh15MinESs=vdslLineAlarmConfThresh15MinESs, vdslLineConfDownSlowMaxDataRate=vdslLineConfDownSlowMaxDataRate, vdslInitFailureNotification=vdslInitFailureNotification, vdslPerf1DayIntervalESs=vdslPerf1DayIntervalESs, vdslPerfDataTable=vdslPerfDataTable, vdslLineAlarmConfThresh15MinLprs=vdslLineAlarmConfThresh15MinLprs, vdslPhysCurrLineRate=vdslPhysCurrLineRate, vdslPerfDataCurr1DayUASs=vdslPerfDataCurr1DayUASs, vdslChan1DayIntervalMoniSecs=vdslChan1DayIntervalMoniSecs, vdslLineConfUpRateMode=vdslLineConfUpRateMode, vdslPerfSESsThreshNotification=vdslPerfSESsThreshNotification, vdslPerfDataCurr15MinLols=vdslPerfDataCurr15MinLols, vdslLineConfUpSlowMaxDataRate=vdslLineConfUpSlowMaxDataRate, vdslLineConfCustomNotch1Start=vdslLineConfCustomNotch1Start, vdslLineAlarmConfThresh15MinUASs=vdslLineAlarmConfThresh15MinUASs, vdslPerfLofsThreshNotification=vdslPerfLofsThreshNotification, vdslLineConfDownPsdTemplate=vdslLineConfDownPsdTemplate, vdslPerfDataInvalidIntervals=vdslPerfDataInvalidIntervals, vdslLineConfApplicableStandard=vdslLineConfApplicableStandard, vdslLineAlarmConfInitFailure=vdslLineAlarmConfInitFailure, vdslLineEntry=vdslLineEntry, vdslLineConfUpMinSnrMgn=vdslLineConfUpMinSnrMgn, vdslLineTable=vdslLineTable, vdslChanCurrTxSlowBurstProtect=vdslChanCurrTxSlowBurstProtect, vdslLineConfProfileTable=vdslLineConfProfileTable, vdslChanCrcBlockLength=vdslChanCrcBlockLength, vdslLineAlarmConfProfile=vdslLineAlarmConfProfile, vdslPerfDataSESs=vdslPerfDataSESs, vdslLineMib=vdslLineMib, vdslPerfDataCurr1DayLofs=vdslPerfDataCurr1DayLofs, vdslGroup=vdslGroup, vdslPerfDataCurr1DayLoss=vdslPerfDataCurr1DayLoss, vdslChan1DayValidIntervals=vdslChan1DayValidIntervals, vdslPerf1DayIntervalInits=vdslPerf1DayIntervalInits, vdslChanCurr15MinTimeElapsed=vdslChanCurr15MinTimeElapsed, vdslPerfDataCurr1DayLprs=vdslPerfDataCurr1DayLprs, vdslPerfDataCurr15MinInits=vdslPerfDataCurr15MinInits, vdslLineConfHamBandMask=vdslLineConfHamBandMask, vdslChanInterleaveDelay=vdslChanInterleaveDelay, vdslPerfESsThreshNotification=vdslPerfESsThreshNotification, vdslLineConfUpTargetSlowBurst=vdslLineConfUpTargetSlowBurst, vdslPerfDataCurr15MinLprs=vdslPerfDataCurr15MinLprs, vdslChanCurr15MinFixedOctets=vdslChanCurr15MinFixedOctets, vdslPerf1DayIntervalLprs=vdslPerf1DayIntervalLprs, vdslLineConfCustomNotch1Stop=vdslLineConfCustomNotch1Stop, vdslChanIntervalBadBlks=vdslChanIntervalBadBlks, vdslLineConfUpPboLevel=vdslLineConfUpPboLevel, vdslLineAlarmConfProfileTable=vdslLineAlarmConfProfileTable, vdslPerfIntervalLols=vdslPerfIntervalLols, vdslChanCurr1DayFixedOctets=vdslChanCurr1DayFixedOctets, vdslLineConfDownSlowMinDataRate=vdslLineConfDownSlowMinDataRate, vdslPerfDataCurr1DaySESs=vdslPerfDataCurr1DaySESs, vdslNotificationGroup=vdslNotificationGroup, vdslPerfUASsThreshNotification=vdslPerfUASsThreshNotification, vdslPerf1DayIntervalEntry=vdslPerf1DayIntervalEntry, vdslLineConfDownMaxPwr=vdslLineConfDownMaxPwr, vdslMibObjects=vdslMibObjects, vdslPhysCurrOutputPwr=vdslPhysCurrOutputPwr, vdslLineAlarmConfThresh15MinLoss=vdslLineAlarmConfThresh15MinLoss, vdslPerfLprsThreshNotification=vdslPerfLprsThreshNotification, vdslPerfIntervalTable=vdslPerfIntervalTable, vdslChan1DayIntervalTable=vdslChan1DayIntervalTable, vdslLineConfUpRateRatio=vdslLineConfUpRateRatio, vdslLineConfDownMaxSnrMgn=vdslLineConfDownMaxSnrMgn, vdslPhysCurrAttainableRate=vdslPhysCurrAttainableRate, vdslPerfIntervalNumber=vdslPerfIntervalNumber, vdslChan1DayIntervalNumber=vdslChan1DayIntervalNumber, vdslPerfDataCurr15MinUASs=vdslPerfDataCurr15MinUASs, vdslChan1DayIntervalBadBlks=vdslChan1DayIntervalBadBlks, vdslLineConfUpMaxSnrMgn=vdslLineConfUpMaxSnrMgn, vdslLineConfDownMaxInterDelay=vdslLineConfDownMaxInterDelay, vdslChanBadBlks=vdslChanBadBlks, vdslLineAlarmConfThresh15MinLofs=vdslLineAlarmConfThresh15MinLofs, vdslPerfDataValidIntervals=vdslPerfDataValidIntervals, vdslLineConfProfile=vdslLineConfProfile, vdslPerfDataLols=vdslPerfDataLols, vdslPerf1DayIntervalLols=vdslPerf1DayIntervalLols, vdslLineConfDownMinSnrMgn=vdslLineConfDownMinSnrMgn, vdslLineConfDownFastMinDataRate=vdslLineConfDownFastMinDataRate, vdslPerfDataCurr1DayTimeElapsed=vdslPerfDataCurr1DayTimeElapsed, vdslChanCurr1DayTimeElapsed=vdslChanCurr1DayTimeElapsed, vdslPerfLossThreshNotification=vdslPerfLossThreshNotification)
