# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=wrong-import-position

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ._patch import *  # pylint: disable=unused-wildcard-import


from ._models import (  # type: ignore
    AgentConfig,
    Animation,
    AssistantMessageItem,
    AudioEchoCancellation,
    AudioInputTranscriptionOptions,
    AudioNoiseReduction,
    AvatarConfig,
    AzureCustomVoice,
    AzurePersonalVoice,
    AzureSemanticDetection,
    AzureSemanticDetectionEn,
    AzureSemanticDetectionMultilingual,
    AzureSemanticVad,
    AzureSemanticVadEn,
    AzureSemanticVadMultilingual,
    AzureStandardVoice,
    AzureVoice,
    Background,
    CachedTokenDetails,
    ClientEvent,
    ClientEventConversationItemCreate,
    ClientEventConversationItemDelete,
    ClientEventConversationItemRetrieve,
    ClientEventConversationItemTruncate,
    ClientEventInputAudioBufferAppend,
    ClientEventInputAudioBufferClear,
    ClientEventInputAudioBufferCommit,
    ClientEventInputAudioClear,
    ClientEventInputAudioTurnAppend,
    ClientEventInputAudioTurnCancel,
    ClientEventInputAudioTurnEnd,
    ClientEventInputAudioTurnStart,
    ClientEventResponseCancel,
    ClientEventResponseCreate,
    ClientEventSessionAvatarConnect,
    ClientEventSessionUpdate,
    ContentPart,
    ConversationItemBase,
    ConversationRequestItem,
    EouDetection,
    ErrorResponse,
    FunctionCallItem,
    FunctionCallOutputItem,
    FunctionTool,
    IceServer,
    InputAudioContentPart,
    InputTextContentPart,
    InputTokenDetails,
    LogProbProperties,
    MCPApprovalResponseRequestItem,
    MCPServer,
    MCPTool,
    MessageContentPart,
    MessageItem,
    OpenAIVoice,
    OutputTextContentPart,
    OutputTokenDetails,
    RequestAudioContentPart,
    RequestImageContentPart,
    RequestSession,
    RequestTextContentPart,
    Response,
    ResponseAudioContentPart,
    ResponseCancelledDetails,
    ResponseCreateParams,
    ResponseFailedDetails,
    ResponseFunctionCallItem,
    ResponseFunctionCallOutputItem,
    ResponseIncompleteDetails,
    ResponseItem,
    ResponseMCPApprovalRequestItem,
    ResponseMCPApprovalResponseItem,
    ResponseMCPCallItem,
    ResponseMCPListToolItem,
    ResponseMessageItem,
    ResponseSession,
    ResponseStatusDetails,
    ResponseTextContentPart,
    ServerEvent,
    ServerEventConversationItemCreated,
    ServerEventConversationItemDeleted,
    ServerEventConversationItemInputAudioTranscriptionCompleted,
    ServerEventConversationItemInputAudioTranscriptionDelta,
    ServerEventConversationItemInputAudioTranscriptionFailed,
    ServerEventConversationItemRetrieved,
    ServerEventConversationItemTruncated,
    ServerEventError,
    ServerEventErrorDetails,
    ServerEventInputAudioBufferCleared,
    ServerEventInputAudioBufferCommitted,
    ServerEventInputAudioBufferSpeechStarted,
    ServerEventInputAudioBufferSpeechStopped,
    ServerEventMcpListToolsCompleted,
    ServerEventMcpListToolsFailed,
    ServerEventMcpListToolsInProgress,
    ServerEventResponseAnimationBlendshapeDelta,
    ServerEventResponseAnimationBlendshapeDone,
    ServerEventResponseAnimationVisemeDelta,
    ServerEventResponseAnimationVisemeDone,
    ServerEventResponseAudioDelta,
    ServerEventResponseAudioDone,
    ServerEventResponseAudioTimestampDelta,
    ServerEventResponseAudioTimestampDone,
    ServerEventResponseAudioTranscriptDelta,
    ServerEventResponseAudioTranscriptDone,
    ServerEventResponseContentPartAdded,
    ServerEventResponseContentPartDone,
    ServerEventResponseCreated,
    ServerEventResponseDone,
    ServerEventResponseFunctionCallArgumentsDelta,
    ServerEventResponseFunctionCallArgumentsDone,
    ServerEventResponseMcpCallArgumentsDelta,
    ServerEventResponseMcpCallArgumentsDone,
    ServerEventResponseMcpCallCompleted,
    ServerEventResponseMcpCallFailed,
    ServerEventResponseMcpCallInProgress,
    ServerEventResponseOutputItemAdded,
    ServerEventResponseOutputItemDone,
    ServerEventResponseTextDelta,
    ServerEventResponseTextDone,
    ServerEventSessionAvatarConnecting,
    ServerEventSessionCreated,
    ServerEventSessionUpdated,
    ServerVad,
    SessionBase,
    SystemMessageItem,
    TokenUsage,
    Tool,
    ToolChoiceFunctionSelection,
    ToolChoiceSelection,
    TurnDetection,
    UserMessageItem,
    VideoCrop,
    VideoParams,
    VideoResolution,
    VoiceLiveErrorDetails,
)

from ._enums import (  # type: ignore
    AnimationOutputType,
    AudioTimestampType,
    AvatarConfigTypes,
    AvatarOutputProtocol,
    AzureVoiceType,
    ClientEventType,
    ContentPartType,
    EouThresholdLevel,
    InputAudioFormat,
    ItemParamStatus,
    ItemType,
    MCPApprovalType,
    MessageRole,
    Modality,
    OpenAIVoiceName,
    OutputAudioFormat,
    PersonalVoiceModels,
    PhotoAvatarBaseModes,
    RequestImageContentPartDetail,
    ResponseItemStatus,
    ResponseStatus,
    ServerEventType,
    ToolChoiceLiteral,
    ToolType,
    TurnDetectionType,
)
from ._patch import __all__ as _patch_all
from ._patch import *
from ._patch import patch_sdk as _patch_sdk

__all__ = [
    "AgentConfig",
    "Animation",
    "AssistantMessageItem",
    "AudioEchoCancellation",
    "AudioInputTranscriptionOptions",
    "AudioNoiseReduction",
    "AvatarConfig",
    "AzureCustomVoice",
    "AzurePersonalVoice",
    "AzureSemanticDetection",
    "AzureSemanticDetectionEn",
    "AzureSemanticDetectionMultilingual",
    "AzureSemanticVad",
    "AzureSemanticVadEn",
    "AzureSemanticVadMultilingual",
    "AzureStandardVoice",
    "AzureVoice",
    "Background",
    "CachedTokenDetails",
    "ClientEvent",
    "ClientEventConversationItemCreate",
    "ClientEventConversationItemDelete",
    "ClientEventConversationItemRetrieve",
    "ClientEventConversationItemTruncate",
    "ClientEventInputAudioBufferAppend",
    "ClientEventInputAudioBufferClear",
    "ClientEventInputAudioBufferCommit",
    "ClientEventInputAudioClear",
    "ClientEventInputAudioTurnAppend",
    "ClientEventInputAudioTurnCancel",
    "ClientEventInputAudioTurnEnd",
    "ClientEventInputAudioTurnStart",
    "ClientEventResponseCancel",
    "ClientEventResponseCreate",
    "ClientEventSessionAvatarConnect",
    "ClientEventSessionUpdate",
    "ContentPart",
    "ConversationItemBase",
    "ConversationRequestItem",
    "EouDetection",
    "ErrorResponse",
    "FunctionCallItem",
    "FunctionCallOutputItem",
    "FunctionTool",
    "IceServer",
    "InputAudioContentPart",
    "InputTextContentPart",
    "InputTokenDetails",
    "LogProbProperties",
    "MCPApprovalResponseRequestItem",
    "MCPServer",
    "MCPTool",
    "MessageContentPart",
    "MessageItem",
    "OpenAIVoice",
    "OutputTextContentPart",
    "OutputTokenDetails",
    "RequestAudioContentPart",
    "RequestImageContentPart",
    "RequestSession",
    "RequestTextContentPart",
    "Response",
    "ResponseAudioContentPart",
    "ResponseCancelledDetails",
    "ResponseCreateParams",
    "ResponseFailedDetails",
    "ResponseFunctionCallItem",
    "ResponseFunctionCallOutputItem",
    "ResponseIncompleteDetails",
    "ResponseItem",
    "ResponseMCPApprovalRequestItem",
    "ResponseMCPApprovalResponseItem",
    "ResponseMCPCallItem",
    "ResponseMCPListToolItem",
    "ResponseMessageItem",
    "ResponseSession",
    "ResponseStatusDetails",
    "ResponseTextContentPart",
    "ServerEvent",
    "ServerEventConversationItemCreated",
    "ServerEventConversationItemDeleted",
    "ServerEventConversationItemInputAudioTranscriptionCompleted",
    "ServerEventConversationItemInputAudioTranscriptionDelta",
    "ServerEventConversationItemInputAudioTranscriptionFailed",
    "ServerEventConversationItemRetrieved",
    "ServerEventConversationItemTruncated",
    "ServerEventError",
    "ServerEventErrorDetails",
    "ServerEventInputAudioBufferCleared",
    "ServerEventInputAudioBufferCommitted",
    "ServerEventInputAudioBufferSpeechStarted",
    "ServerEventInputAudioBufferSpeechStopped",
    "ServerEventMcpListToolsCompleted",
    "ServerEventMcpListToolsFailed",
    "ServerEventMcpListToolsInProgress",
    "ServerEventResponseAnimationBlendshapeDelta",
    "ServerEventResponseAnimationBlendshapeDone",
    "ServerEventResponseAnimationVisemeDelta",
    "ServerEventResponseAnimationVisemeDone",
    "ServerEventResponseAudioDelta",
    "ServerEventResponseAudioDone",
    "ServerEventResponseAudioTimestampDelta",
    "ServerEventResponseAudioTimestampDone",
    "ServerEventResponseAudioTranscriptDelta",
    "ServerEventResponseAudioTranscriptDone",
    "ServerEventResponseContentPartAdded",
    "ServerEventResponseContentPartDone",
    "ServerEventResponseCreated",
    "ServerEventResponseDone",
    "ServerEventResponseFunctionCallArgumentsDelta",
    "ServerEventResponseFunctionCallArgumentsDone",
    "ServerEventResponseMcpCallArgumentsDelta",
    "ServerEventResponseMcpCallArgumentsDone",
    "ServerEventResponseMcpCallCompleted",
    "ServerEventResponseMcpCallFailed",
    "ServerEventResponseMcpCallInProgress",
    "ServerEventResponseOutputItemAdded",
    "ServerEventResponseOutputItemDone",
    "ServerEventResponseTextDelta",
    "ServerEventResponseTextDone",
    "ServerEventSessionAvatarConnecting",
    "ServerEventSessionCreated",
    "ServerEventSessionUpdated",
    "ServerVad",
    "SessionBase",
    "SystemMessageItem",
    "TokenUsage",
    "Tool",
    "ToolChoiceFunctionSelection",
    "ToolChoiceSelection",
    "TurnDetection",
    "UserMessageItem",
    "VideoCrop",
    "VideoParams",
    "VideoResolution",
    "VoiceLiveErrorDetails",
    "AnimationOutputType",
    "AudioTimestampType",
    "AvatarConfigTypes",
    "AvatarOutputProtocol",
    "AzureVoiceType",
    "ClientEventType",
    "ContentPartType",
    "EouThresholdLevel",
    "InputAudioFormat",
    "ItemParamStatus",
    "ItemType",
    "MCPApprovalType",
    "MessageRole",
    "Modality",
    "OpenAIVoiceName",
    "OutputAudioFormat",
    "PersonalVoiceModels",
    "PhotoAvatarBaseModes",
    "RequestImageContentPartDetail",
    "ResponseItemStatus",
    "ResponseStatus",
    "ServerEventType",
    "ToolChoiceLiteral",
    "ToolType",
    "TurnDetectionType",
]
__all__.extend([p for p in _patch_all if p not in __all__])  # pyright: ignore
_patch_sdk()
