# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from azure.onlineexperimentation import OnlineExperimentationClient
from devtools_testutils import AzureRecordedTestCase, EnvironmentVariableLoader
import functools

class OnlineExperimentationClientTestBase(AzureRecordedTestCase):

    def create_client(self, endpoint) -> OnlineExperimentationClient:
        credential = self.get_credential(OnlineExperimentationClient)
        return self.create_client_from_credential(
            OnlineExperimentationClient,
            credential=credential,
            endpoint=endpoint,
        )


OnlineExperimentationPreparer = functools.partial(
    EnvironmentVariableLoader,
    "azure_onlineexperimentation",
    azure_onlineexperimentation_endpoint="https://fake_workspaceId.eastus2.exp.azure.net",
)
