# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iothub.aio import IotHubClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIotHubIotHubResourceOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IotHubClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_get(self, resource_group):
        response = await self.client.iot_hub_resource.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.iot_hub_resource.begin_create_or_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                iot_hub_description={
                    "location": "str",
                    "sku": {"name": "str", "capacity": 0, "tier": "str"},
                    "etag": "str",
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "name": "str",
                    "properties": {
                        "allowedFqdnList": ["str"],
                        "authorizationPolicies": [
                            {"keyName": "str", "rights": "str", "primaryKey": "str", "secondaryKey": "str"}
                        ],
                        "cloudToDevice": {
                            "defaultTtlAsIso8601": "1 day, 0:00:00",
                            "feedback": {
                                "lockDurationAsIso8601": "1 day, 0:00:00",
                                "maxDeliveryCount": 0,
                                "ttlAsIso8601": "1 day, 0:00:00",
                            },
                            "maxDeliveryCount": 0,
                        },
                        "comments": "str",
                        "disableDeviceSAS": bool,
                        "disableLocalAuth": bool,
                        "disableModuleSAS": bool,
                        "enableDataResidency": bool,
                        "enableFileUploadNotifications": bool,
                        "eventHubEndpoints": {
                            "str": {
                                "endpoint": "str",
                                "partitionCount": 0,
                                "partitionIds": ["str"],
                                "path": "str",
                                "retentionTimeInDays": 0,
                            }
                        },
                        "features": "str",
                        "hostName": "str",
                        "ipFilterRules": [{"action": "str", "filterName": "str", "ipMask": "str"}],
                        "locations": [{"location": "str", "role": "str"}],
                        "messagingEndpoints": {
                            "str": {
                                "lockDurationAsIso8601": "1 day, 0:00:00",
                                "maxDeliveryCount": 0,
                                "ttlAsIso8601": "1 day, 0:00:00",
                            }
                        },
                        "minTlsVersion": "str",
                        "networkRuleSets": {
                            "applyToBuiltInEventHubEndpoint": bool,
                            "ipRules": [{"filterName": "str", "ipMask": "str", "action": "Allow"}],
                            "defaultAction": "Deny",
                        },
                        "privateEndpointConnections": [
                            {
                                "properties": {
                                    "privateLinkServiceConnectionState": {
                                        "description": "str",
                                        "status": "str",
                                        "actionsRequired": "str",
                                    },
                                    "privateEndpoint": {"id": "str"},
                                },
                                "id": "str",
                                "name": "str",
                                "type": "str",
                            }
                        ],
                        "provisioningState": "str",
                        "publicNetworkAccess": "str",
                        "restrictOutboundNetworkAccess": bool,
                        "routing": {
                            "endpoints": {
                                "cosmosDBSqlContainers": [
                                    {
                                        "containerName": "str",
                                        "databaseName": "str",
                                        "endpointUri": "str",
                                        "name": "str",
                                        "authenticationType": "str",
                                        "id": "str",
                                        "identity": {"userAssignedIdentity": "str"},
                                        "partitionKeyName": "str",
                                        "partitionKeyTemplate": "str",
                                        "primaryKey": "str",
                                        "resourceGroup": "str",
                                        "secondaryKey": "str",
                                        "subscriptionId": "str",
                                    }
                                ],
                                "eventHubs": [
                                    {
                                        "name": "str",
                                        "authenticationType": "str",
                                        "connectionString": "str",
                                        "endpointUri": "str",
                                        "entityPath": "str",
                                        "id": "str",
                                        "identity": {"userAssignedIdentity": "str"},
                                        "resourceGroup": "str",
                                        "subscriptionId": "str",
                                    }
                                ],
                                "serviceBusQueues": [
                                    {
                                        "name": "str",
                                        "authenticationType": "str",
                                        "connectionString": "str",
                                        "endpointUri": "str",
                                        "entityPath": "str",
                                        "id": "str",
                                        "identity": {"userAssignedIdentity": "str"},
                                        "resourceGroup": "str",
                                        "subscriptionId": "str",
                                    }
                                ],
                                "serviceBusTopics": [
                                    {
                                        "name": "str",
                                        "authenticationType": "str",
                                        "connectionString": "str",
                                        "endpointUri": "str",
                                        "entityPath": "str",
                                        "id": "str",
                                        "identity": {"userAssignedIdentity": "str"},
                                        "resourceGroup": "str",
                                        "subscriptionId": "str",
                                    }
                                ],
                                "storageContainers": [
                                    {
                                        "containerName": "str",
                                        "name": "str",
                                        "authenticationType": "str",
                                        "batchFrequencyInSeconds": 0,
                                        "connectionString": "str",
                                        "encoding": "str",
                                        "endpointUri": "str",
                                        "fileNameFormat": "str",
                                        "id": "str",
                                        "identity": {"userAssignedIdentity": "str"},
                                        "maxChunkSizeInBytes": 0,
                                        "resourceGroup": "str",
                                        "subscriptionId": "str",
                                    }
                                ],
                            },
                            "enrichments": [{"endpointNames": ["str"], "key": "str", "value": "str"}],
                            "fallbackRoute": {
                                "endpointNames": ["str"],
                                "isEnabled": bool,
                                "source": "str",
                                "condition": "str",
                                "name": "str",
                            },
                            "routes": [
                                {
                                    "endpointNames": ["str"],
                                    "isEnabled": bool,
                                    "name": "str",
                                    "source": "str",
                                    "condition": "str",
                                }
                            ],
                        },
                        "state": "str",
                        "storageEndpoints": {
                            "str": {
                                "connectionString": "str",
                                "containerName": "str",
                                "authenticationType": "str",
                                "identity": {"userAssignedIdentity": "str"},
                                "sasTtlAsIso8601": "1 day, 0:00:00",
                            }
                        },
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2023-06-30",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_begin_update(self, resource_group):
        response = await (
            await self.client.iot_hub_resource.begin_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                iot_hub_tags={"tags": {"str": "str"}},
                api_version="2023-06-30",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_begin_delete(self, resource_group):
        response = await (
            await self.client.iot_hub_resource.begin_delete(
                resource_group_name=resource_group.name,
                resource_name="str",
                api_version="2023-06-30",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_list_by_subscription(self, resource_group):
        response = self.client.iot_hub_resource.list_by_subscription(
            api_version="2023-06-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_list_by_resource_group(self, resource_group):
        response = self.client.iot_hub_resource.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-06-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_get_stats(self, resource_group):
        response = await self.client.iot_hub_resource.get_stats(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_get_valid_skus(self, resource_group):
        response = self.client.iot_hub_resource.get_valid_skus(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-06-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_list_event_hub_consumer_groups(self, resource_group):
        response = self.client.iot_hub_resource.list_event_hub_consumer_groups(
            resource_group_name=resource_group.name,
            resource_name="str",
            event_hub_endpoint_name="str",
            api_version="2023-06-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_get_event_hub_consumer_group(self, resource_group):
        response = await self.client.iot_hub_resource.get_event_hub_consumer_group(
            resource_group_name=resource_group.name,
            resource_name="str",
            event_hub_endpoint_name="str",
            name="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_create_event_hub_consumer_group(self, resource_group):
        response = await self.client.iot_hub_resource.create_event_hub_consumer_group(
            resource_group_name=resource_group.name,
            resource_name="str",
            event_hub_endpoint_name="str",
            name="str",
            consumer_group_body={"properties": {"name": "str"}},
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_delete_event_hub_consumer_group(self, resource_group):
        response = await self.client.iot_hub_resource.delete_event_hub_consumer_group(
            resource_group_name=resource_group.name,
            resource_name="str",
            event_hub_endpoint_name="str",
            name="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_list_jobs(self, resource_group):
        response = self.client.iot_hub_resource.list_jobs(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-06-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_get_job(self, resource_group):
        response = await self.client.iot_hub_resource.get_job(
            resource_group_name=resource_group.name,
            resource_name="str",
            job_id="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_get_quota_metrics(self, resource_group):
        response = self.client.iot_hub_resource.get_quota_metrics(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-06-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_get_endpoint_health(self, resource_group):
        response = self.client.iot_hub_resource.get_endpoint_health(
            resource_group_name=resource_group.name,
            iot_hub_name="str",
            api_version="2023-06-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_check_name_availability(self, resource_group):
        response = await self.client.iot_hub_resource.check_name_availability(
            operation_inputs={"name": "str"},
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_test_all_routes(self, resource_group):
        response = await self.client.iot_hub_resource.test_all_routes(
            iot_hub_name="str",
            resource_group_name=resource_group.name,
            input={
                "message": {"appProperties": {"str": "str"}, "body": "str", "systemProperties": {"str": "str"}},
                "routingSource": "str",
                "twin": {"properties": {"desired": {}, "reported": {}}, "tags": {}},
            },
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_test_route(self, resource_group):
        response = await self.client.iot_hub_resource.test_route(
            iot_hub_name="str",
            resource_group_name=resource_group.name,
            input={
                "route": {
                    "endpointNames": ["str"],
                    "isEnabled": bool,
                    "name": "str",
                    "source": "str",
                    "condition": "str",
                },
                "message": {"appProperties": {"str": "str"}, "body": "str", "systemProperties": {"str": "str"}},
                "twin": {"properties": {"desired": {}, "reported": {}}, "tags": {}},
            },
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_list_keys(self, resource_group):
        response = self.client.iot_hub_resource.list_keys(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-06-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_get_keys_for_key_name(self, resource_group):
        response = await self.client.iot_hub_resource.get_keys_for_key_name(
            resource_group_name=resource_group.name,
            resource_name="str",
            key_name="str",
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_export_devices(self, resource_group):
        response = await self.client.iot_hub_resource.export_devices(
            resource_group_name=resource_group.name,
            resource_name="str",
            export_devices_parameters={
                "excludeKeys": bool,
                "exportBlobContainerUri": "str",
                "authenticationType": "str",
                "configurationsBlobName": "str",
                "exportBlobName": "str",
                "identity": {"userAssignedIdentity": "str"},
                "includeConfigurations": bool,
            },
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_iot_hub_resource_import_devices(self, resource_group):
        response = await self.client.iot_hub_resource.import_devices(
            resource_group_name=resource_group.name,
            resource_name="str",
            import_devices_parameters={
                "inputBlobContainerUri": "str",
                "outputBlobContainerUri": "str",
                "authenticationType": "str",
                "configurationsBlobName": "str",
                "identity": {"userAssignedIdentity": "str"},
                "includeConfigurations": bool,
                "inputBlobName": "str",
                "outputBlobName": "str",
            },
            api_version="2023-06-30",
        )

        # please add some check logic here by yourself
        # ...
