# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._iot_hub_resource_operations import (
    build_check_name_availability_request,
    build_create_event_hub_consumer_group_request,
    build_create_or_update_request,
    build_delete_event_hub_consumer_group_request,
    build_delete_request,
    build_export_devices_request,
    build_get_endpoint_health_request,
    build_get_event_hub_consumer_group_request,
    build_get_job_request,
    build_get_keys_for_key_name_request,
    build_get_quota_metrics_request,
    build_get_request,
    build_get_stats_request,
    build_get_valid_skus_request,
    build_import_devices_request,
    build_list_by_resource_group_request,
    build_list_by_subscription_request,
    build_list_event_hub_consumer_groups_request,
    build_list_jobs_request,
    build_list_keys_request,
    build_test_all_routes_request,
    build_test_route_request,
    build_update_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class IotHubResourceOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.iothub.v2021_03_03_preview.aio.IotHubClient`'s
        :attr:`iot_hub_resource` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, resource_group_name: str, resource_name: str, **kwargs: Any) -> _models.IotHubDescription:
        """Get the non-security related metadata of an IoT hub.

        Get the non-security related metadata of an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IotHubDescription or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.IotHubDescription] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("IotHubDescription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
    }

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        resource_name: str,
        iot_hub_description: Union[_models.IotHubDescription, IO],
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.IotHubDescription:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IotHubDescription] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(iot_hub_description, (IO, bytes)):
            _content = iot_hub_description
        else:
            _json = self._serialize.body(iot_hub_description, "IotHubDescription")

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_or_update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("IotHubDescription", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("IotHubDescription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _create_or_update_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
    }

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        resource_name: str,
        iot_hub_description: _models.IotHubDescription,
        if_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.IotHubDescription]:
        """Create or update the metadata of an IoT hub.

        Create or update the metadata of an Iot hub. The usual pattern to modify a property is to
        retrieve the IoT hub metadata and security metadata, and then combine them with the modified
        values in a new body to update the IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param iot_hub_description: The IoT hub metadata and security metadata. Required.
        :type iot_hub_description: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription
        :param if_match: ETag of the IoT Hub. Do not specify for creating a brand new IoT Hub. Required
         to update an existing IoT Hub. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either IotHubDescription or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        resource_name: str,
        iot_hub_description: IO,
        if_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.IotHubDescription]:
        """Create or update the metadata of an IoT hub.

        Create or update the metadata of an Iot hub. The usual pattern to modify a property is to
        retrieve the IoT hub metadata and security metadata, and then combine them with the modified
        values in a new body to update the IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param iot_hub_description: The IoT hub metadata and security metadata. Required.
        :type iot_hub_description: IO
        :param if_match: ETag of the IoT Hub. Do not specify for creating a brand new IoT Hub. Required
         to update an existing IoT Hub. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either IotHubDescription or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        resource_name: str,
        iot_hub_description: Union[_models.IotHubDescription, IO],
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.IotHubDescription]:
        """Create or update the metadata of an IoT hub.

        Create or update the metadata of an Iot hub. The usual pattern to modify a property is to
        retrieve the IoT hub metadata and security metadata, and then combine them with the modified
        values in a new body to update the IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param iot_hub_description: The IoT hub metadata and security metadata. Is either a
         IotHubDescription type or a IO type. Required.
        :type iot_hub_description: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription or
         IO
        :param if_match: ETag of the IoT Hub. Do not specify for creating a brand new IoT Hub. Required
         to update an existing IoT Hub. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either IotHubDescription or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IotHubDescription] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                resource_name=resource_name,
                iot_hub_description=iot_hub_description,
                if_match=if_match,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("IotHubDescription", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_or_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
    }

    async def _update_initial(
        self, resource_group_name: str, resource_name: str, iot_hub_tags: Union[_models.TagsResource, IO], **kwargs: Any
    ) -> _models.IotHubDescription:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IotHubDescription] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(iot_hub_tags, (IO, bytes)):
            _content = iot_hub_tags
        else:
            _json = self._serialize.body(iot_hub_tags, "TagsResource")

        request = build_update_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("IotHubDescription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
    }

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        resource_name: str,
        iot_hub_tags: _models.TagsResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.IotHubDescription]:
        """Update an existing IoT Hubs tags.

        Update an existing IoT Hub tags. to update other fields use the CreateOrUpdate method.

        :param resource_group_name: Resource group identifier. Required.
        :type resource_group_name: str
        :param resource_name: Name of iot hub to update. Required.
        :type resource_name: str
        :param iot_hub_tags: Updated tag information to set into the iot hub instance. Required.
        :type iot_hub_tags: ~azure.mgmt.iothub.v2021_03_03_preview.models.TagsResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either IotHubDescription or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        resource_name: str,
        iot_hub_tags: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.IotHubDescription]:
        """Update an existing IoT Hubs tags.

        Update an existing IoT Hub tags. to update other fields use the CreateOrUpdate method.

        :param resource_group_name: Resource group identifier. Required.
        :type resource_group_name: str
        :param resource_name: Name of iot hub to update. Required.
        :type resource_name: str
        :param iot_hub_tags: Updated tag information to set into the iot hub instance. Required.
        :type iot_hub_tags: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either IotHubDescription or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update(
        self, resource_group_name: str, resource_name: str, iot_hub_tags: Union[_models.TagsResource, IO], **kwargs: Any
    ) -> AsyncLROPoller[_models.IotHubDescription]:
        """Update an existing IoT Hubs tags.

        Update an existing IoT Hub tags. to update other fields use the CreateOrUpdate method.

        :param resource_group_name: Resource group identifier. Required.
        :type resource_group_name: str
        :param resource_name: Name of iot hub to update. Required.
        :type resource_name: str
        :param iot_hub_tags: Updated tag information to set into the iot hub instance. Is either a
         TagsResource type or a IO type. Required.
        :type iot_hub_tags: ~azure.mgmt.iothub.v2021_03_03_preview.models.TagsResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either IotHubDescription or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IotHubDescription] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                resource_group_name=resource_group_name,
                resource_name=resource_name,
                iot_hub_tags=iot_hub_tags,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("IotHubDescription", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
    }

    async def _delete_initial(
        self, resource_group_name: str, resource_name: str, **kwargs: Any
    ) -> Union[_models.IotHubDescription, _models.ErrorDetails]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[Union[_models.IotHubDescription, _models.ErrorDetails]] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._delete_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("IotHubDescription", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("IotHubDescription", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("ErrorDetails", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _delete_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
    }

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, resource_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.IotHubDescription]:
        """Delete an IoT hub.

        Delete an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either IotHubDescription or An instance of
         AsyncLROPoller that returns either ErrorDetails or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
         or
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.iothub.v2021_03_03_preview.models.ErrorDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.IotHubDescription] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                resource_name=resource_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("IotHubDescription", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
    }

    @distributed_trace
    def list_by_subscription(self, **kwargs: Any) -> AsyncIterable["_models.IotHubDescription"]:
        """Get all the IoT hubs in a subscription.

        Get all the IoT hubs in a subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either IotHubDescription or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.IotHubDescriptionListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_subscription.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("IotHubDescriptionListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_subscription.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Devices/IotHubs"}

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.IotHubDescription"]:
        """Get all the IoT hubs in a resource group.

        Get all the IoT hubs in a resource group.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either IotHubDescription or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.IotHubDescriptionListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("IotHubDescriptionListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs"
    }

    @distributed_trace_async
    async def get_stats(
        self, resource_group_name: str, resource_name: str, **kwargs: Any
    ) -> _models.RegistryStatistics:
        """Get the statistics from an IoT hub.

        Get the statistics from an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RegistryStatistics or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.RegistryStatistics
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.RegistryStatistics] = kwargs.pop("cls", None)

        request = build_get_stats_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_stats.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RegistryStatistics", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_stats.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubStats"
    }

    @distributed_trace
    def get_valid_skus(
        self, resource_group_name: str, resource_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.IotHubSkuDescription"]:
        """Get the list of valid SKUs for an IoT hub.

        Get the list of valid SKUs for an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either IotHubSkuDescription or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubSkuDescription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.IotHubSkuDescriptionListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_valid_skus_request(
                    resource_group_name=resource_group_name,
                    resource_name=resource_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_valid_skus.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("IotHubSkuDescriptionListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_valid_skus.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/skus"
    }

    @distributed_trace
    def list_event_hub_consumer_groups(
        self, resource_group_name: str, resource_name: str, event_hub_endpoint_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.EventHubConsumerGroupInfo"]:
        """Get a list of the consumer groups in the Event Hub-compatible device-to-cloud endpoint in an
        IoT hub.

        Get a list of the consumer groups in the Event Hub-compatible device-to-cloud endpoint in an
        IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param event_hub_endpoint_name: The name of the Event Hub-compatible endpoint. Required.
        :type event_hub_endpoint_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either EventHubConsumerGroupInfo or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubConsumerGroupInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.EventHubConsumerGroupsListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_event_hub_consumer_groups_request(
                    resource_group_name=resource_group_name,
                    resource_name=resource_name,
                    event_hub_endpoint_name=event_hub_endpoint_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_event_hub_consumer_groups.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("EventHubConsumerGroupsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_event_hub_consumer_groups.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups"
    }

    @distributed_trace_async
    async def get_event_hub_consumer_group(
        self, resource_group_name: str, resource_name: str, event_hub_endpoint_name: str, name: str, **kwargs: Any
    ) -> _models.EventHubConsumerGroupInfo:
        """Get a consumer group from the Event Hub-compatible device-to-cloud endpoint for an IoT hub.

        Get a consumer group from the Event Hub-compatible device-to-cloud endpoint for an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param event_hub_endpoint_name: The name of the Event Hub-compatible endpoint in the IoT hub.
         Required.
        :type event_hub_endpoint_name: str
        :param name: The name of the consumer group to retrieve. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EventHubConsumerGroupInfo or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubConsumerGroupInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.EventHubConsumerGroupInfo] = kwargs.pop("cls", None)

        request = build_get_event_hub_consumer_group_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            event_hub_endpoint_name=event_hub_endpoint_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_event_hub_consumer_group.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("EventHubConsumerGroupInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_event_hub_consumer_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}"
    }

    @overload
    async def create_event_hub_consumer_group(
        self,
        resource_group_name: str,
        resource_name: str,
        event_hub_endpoint_name: str,
        name: str,
        consumer_group_body: _models.EventHubConsumerGroupBodyDescription,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EventHubConsumerGroupInfo:
        """Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.

        Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param event_hub_endpoint_name: The name of the Event Hub-compatible endpoint in the IoT hub.
         Required.
        :type event_hub_endpoint_name: str
        :param name: The name of the consumer group to add. Required.
        :type name: str
        :param consumer_group_body: The consumer group to add. Required.
        :type consumer_group_body:
         ~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubConsumerGroupBodyDescription
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EventHubConsumerGroupInfo or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubConsumerGroupInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_event_hub_consumer_group(
        self,
        resource_group_name: str,
        resource_name: str,
        event_hub_endpoint_name: str,
        name: str,
        consumer_group_body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EventHubConsumerGroupInfo:
        """Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.

        Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param event_hub_endpoint_name: The name of the Event Hub-compatible endpoint in the IoT hub.
         Required.
        :type event_hub_endpoint_name: str
        :param name: The name of the consumer group to add. Required.
        :type name: str
        :param consumer_group_body: The consumer group to add. Required.
        :type consumer_group_body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EventHubConsumerGroupInfo or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubConsumerGroupInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_event_hub_consumer_group(
        self,
        resource_group_name: str,
        resource_name: str,
        event_hub_endpoint_name: str,
        name: str,
        consumer_group_body: Union[_models.EventHubConsumerGroupBodyDescription, IO],
        **kwargs: Any
    ) -> _models.EventHubConsumerGroupInfo:
        """Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.

        Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param event_hub_endpoint_name: The name of the Event Hub-compatible endpoint in the IoT hub.
         Required.
        :type event_hub_endpoint_name: str
        :param name: The name of the consumer group to add. Required.
        :type name: str
        :param consumer_group_body: The consumer group to add. Is either a
         EventHubConsumerGroupBodyDescription type or a IO type. Required.
        :type consumer_group_body:
         ~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubConsumerGroupBodyDescription or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EventHubConsumerGroupInfo or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubConsumerGroupInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EventHubConsumerGroupInfo] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(consumer_group_body, (IO, bytes)):
            _content = consumer_group_body
        else:
            _json = self._serialize.body(consumer_group_body, "EventHubConsumerGroupBodyDescription")

        request = build_create_event_hub_consumer_group_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            event_hub_endpoint_name=event_hub_endpoint_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_event_hub_consumer_group.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("EventHubConsumerGroupInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_event_hub_consumer_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}"
    }

    @distributed_trace_async
    async def delete_event_hub_consumer_group(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, resource_name: str, event_hub_endpoint_name: str, name: str, **kwargs: Any
    ) -> None:
        """Delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.

        Delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param event_hub_endpoint_name: The name of the Event Hub-compatible endpoint in the IoT hub.
         Required.
        :type event_hub_endpoint_name: str
        :param name: The name of the consumer group to delete. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_event_hub_consumer_group_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            event_hub_endpoint_name=event_hub_endpoint_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_event_hub_consumer_group.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_event_hub_consumer_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}"
    }

    @distributed_trace
    def list_jobs(
        self, resource_group_name: str, resource_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.JobResponse"]:
        """Get a list of all the jobs in an IoT hub. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.

        Get a list of all the jobs in an IoT hub. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either JobResponse or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothub.v2021_03_03_preview.models.JobResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.JobResponseListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_jobs_request(
                    resource_group_name=resource_group_name,
                    resource_name=resource_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_jobs.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("JobResponseListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_jobs.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs"
    }

    @distributed_trace_async
    async def get_job(
        self, resource_group_name: str, resource_name: str, job_id: str, **kwargs: Any
    ) -> _models.JobResponse:
        """Get the details of a job from an IoT hub. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.

        Get the details of a job from an IoT hub. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param job_id: The job identifier. Required.
        :type job_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobResponse or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.JobResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.JobResponse] = kwargs.pop("cls", None)

        request = build_get_job_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            job_id=job_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_job.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("JobResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs/{jobId}"
    }

    @distributed_trace
    def get_quota_metrics(
        self, resource_group_name: str, resource_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.IotHubQuotaMetricInfo"]:
        """Get the quota metrics for an IoT hub.

        Get the quota metrics for an IoT hub.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either IotHubQuotaMetricInfo or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubQuotaMetricInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.IotHubQuotaMetricInfoListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_quota_metrics_request(
                    resource_group_name=resource_group_name,
                    resource_name=resource_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_quota_metrics.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("IotHubQuotaMetricInfoListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_quota_metrics.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/quotaMetrics"
    }

    @distributed_trace
    def get_endpoint_health(
        self, resource_group_name: str, iot_hub_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.EndpointHealthData"]:
        """Get the health for routing endpoints.

        Get the health for routing endpoints.

        :param resource_group_name: Required.
        :type resource_group_name: str
        :param iot_hub_name: Required.
        :type iot_hub_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either EndpointHealthData or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothub.v2021_03_03_preview.models.EndpointHealthData]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.EndpointHealthDataListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_endpoint_health_request(
                    resource_group_name=resource_group_name,
                    iot_hub_name=iot_hub_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_endpoint_health.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("EndpointHealthDataListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_endpoint_health.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routingEndpointsHealth"
    }

    @overload
    async def check_name_availability(
        self, operation_inputs: _models.OperationInputs, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IotHubNameAvailabilityInfo:
        """Check if an IoT hub name is available.

        Check if an IoT hub name is available.

        :param operation_inputs: Set the name parameter in the OperationInputs structure to the name of
         the IoT hub to check. Required.
        :type operation_inputs: ~azure.mgmt.iothub.v2021_03_03_preview.models.OperationInputs
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IotHubNameAvailabilityInfo or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubNameAvailabilityInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_name_availability(
        self, operation_inputs: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IotHubNameAvailabilityInfo:
        """Check if an IoT hub name is available.

        Check if an IoT hub name is available.

        :param operation_inputs: Set the name parameter in the OperationInputs structure to the name of
         the IoT hub to check. Required.
        :type operation_inputs: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IotHubNameAvailabilityInfo or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubNameAvailabilityInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def check_name_availability(
        self, operation_inputs: Union[_models.OperationInputs, IO], **kwargs: Any
    ) -> _models.IotHubNameAvailabilityInfo:
        """Check if an IoT hub name is available.

        Check if an IoT hub name is available.

        :param operation_inputs: Set the name parameter in the OperationInputs structure to the name of
         the IoT hub to check. Is either a OperationInputs type or a IO type. Required.
        :type operation_inputs: ~azure.mgmt.iothub.v2021_03_03_preview.models.OperationInputs or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IotHubNameAvailabilityInfo or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubNameAvailabilityInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IotHubNameAvailabilityInfo] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(operation_inputs, (IO, bytes)):
            _content = operation_inputs
        else:
            _json = self._serialize.body(operation_inputs, "OperationInputs")

        request = build_check_name_availability_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.check_name_availability.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("IotHubNameAvailabilityInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_name_availability.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkNameAvailability"
    }

    @overload
    async def test_all_routes(
        self,
        iot_hub_name: str,
        resource_group_name: str,
        input: _models.TestAllRoutesInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TestAllRoutesResult:
        """Test all routes.

        Test all routes configured in this Iot Hub.

        :param iot_hub_name: IotHub to be tested. Required.
        :type iot_hub_name: str
        :param resource_group_name: resource group which Iot Hub belongs to. Required.
        :type resource_group_name: str
        :param input: Input for testing all routes. Required.
        :type input: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestAllRoutesInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TestAllRoutesResult or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestAllRoutesResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def test_all_routes(
        self,
        iot_hub_name: str,
        resource_group_name: str,
        input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TestAllRoutesResult:
        """Test all routes.

        Test all routes configured in this Iot Hub.

        :param iot_hub_name: IotHub to be tested. Required.
        :type iot_hub_name: str
        :param resource_group_name: resource group which Iot Hub belongs to. Required.
        :type resource_group_name: str
        :param input: Input for testing all routes. Required.
        :type input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TestAllRoutesResult or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestAllRoutesResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def test_all_routes(
        self, iot_hub_name: str, resource_group_name: str, input: Union[_models.TestAllRoutesInput, IO], **kwargs: Any
    ) -> _models.TestAllRoutesResult:
        """Test all routes.

        Test all routes configured in this Iot Hub.

        :param iot_hub_name: IotHub to be tested. Required.
        :type iot_hub_name: str
        :param resource_group_name: resource group which Iot Hub belongs to. Required.
        :type resource_group_name: str
        :param input: Input for testing all routes. Is either a TestAllRoutesInput type or a IO type.
         Required.
        :type input: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestAllRoutesInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TestAllRoutesResult or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestAllRoutesResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TestAllRoutesResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(input, (IO, bytes)):
            _content = input
        else:
            _json = self._serialize.body(input, "TestAllRoutesInput")

        request = build_test_all_routes_request(
            iot_hub_name=iot_hub_name,
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.test_all_routes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("TestAllRoutesResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    test_all_routes.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routing/routes/$testall"
    }

    @overload
    async def test_route(
        self,
        iot_hub_name: str,
        resource_group_name: str,
        input: _models.TestRouteInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TestRouteResult:
        """Test the new route.

        Test the new route for this Iot Hub.

        :param iot_hub_name: IotHub to be tested. Required.
        :type iot_hub_name: str
        :param resource_group_name: resource group which Iot Hub belongs to. Required.
        :type resource_group_name: str
        :param input: Route that needs to be tested. Required.
        :type input: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestRouteInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TestRouteResult or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestRouteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def test_route(
        self,
        iot_hub_name: str,
        resource_group_name: str,
        input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TestRouteResult:
        """Test the new route.

        Test the new route for this Iot Hub.

        :param iot_hub_name: IotHub to be tested. Required.
        :type iot_hub_name: str
        :param resource_group_name: resource group which Iot Hub belongs to. Required.
        :type resource_group_name: str
        :param input: Route that needs to be tested. Required.
        :type input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TestRouteResult or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestRouteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def test_route(
        self, iot_hub_name: str, resource_group_name: str, input: Union[_models.TestRouteInput, IO], **kwargs: Any
    ) -> _models.TestRouteResult:
        """Test the new route.

        Test the new route for this Iot Hub.

        :param iot_hub_name: IotHub to be tested. Required.
        :type iot_hub_name: str
        :param resource_group_name: resource group which Iot Hub belongs to. Required.
        :type resource_group_name: str
        :param input: Route that needs to be tested. Is either a TestRouteInput type or a IO type.
         Required.
        :type input: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestRouteInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TestRouteResult or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestRouteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TestRouteResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(input, (IO, bytes)):
            _content = input
        else:
            _json = self._serialize.body(input, "TestRouteInput")

        request = build_test_route_request(
            iot_hub_name=iot_hub_name,
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.test_route.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("TestRouteResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    test_route.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routing/routes/$testnew"
    }

    @distributed_trace
    def list_keys(
        self, resource_group_name: str, resource_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SharedAccessSignatureAuthorizationRule"]:
        """Get the security metadata for an IoT hub. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.

        Get the security metadata for an IoT hub. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SharedAccessSignatureAuthorizationRule or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.iothub.v2021_03_03_preview.models.SharedAccessSignatureAuthorizationRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.SharedAccessSignatureAuthorizationRuleListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_keys_request(
                    resource_group_name=resource_group_name,
                    resource_name=resource_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_keys.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SharedAccessSignatureAuthorizationRuleListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_keys.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/listkeys"
    }

    @distributed_trace_async
    async def get_keys_for_key_name(
        self, resource_group_name: str, resource_name: str, key_name: str, **kwargs: Any
    ) -> _models.SharedAccessSignatureAuthorizationRule:
        """Get a shared access policy by name from an IoT hub. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.

        Get a shared access policy by name from an IoT hub. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param key_name: The name of the shared access policy. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SharedAccessSignatureAuthorizationRule or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.SharedAccessSignatureAuthorizationRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        cls: ClsType[_models.SharedAccessSignatureAuthorizationRule] = kwargs.pop("cls", None)

        request = build_get_keys_for_key_name_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            key_name=key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_keys_for_key_name.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SharedAccessSignatureAuthorizationRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_keys_for_key_name.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubKeys/{keyName}/listkeys"
    }

    @overload
    async def export_devices(
        self,
        resource_group_name: str,
        resource_name: str,
        export_devices_parameters: _models.ExportDevicesRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.JobResponse:
        """Exports all the device identities in the IoT hub identity registry to an Azure Storage blob
        container. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        Exports all the device identities in the IoT hub identity registry to an Azure Storage blob
        container. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param export_devices_parameters: The parameters that specify the export devices operation.
         Required.
        :type export_devices_parameters:
         ~azure.mgmt.iothub.v2021_03_03_preview.models.ExportDevicesRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobResponse or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.JobResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def export_devices(
        self,
        resource_group_name: str,
        resource_name: str,
        export_devices_parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.JobResponse:
        """Exports all the device identities in the IoT hub identity registry to an Azure Storage blob
        container. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        Exports all the device identities in the IoT hub identity registry to an Azure Storage blob
        container. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param export_devices_parameters: The parameters that specify the export devices operation.
         Required.
        :type export_devices_parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobResponse or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.JobResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def export_devices(
        self,
        resource_group_name: str,
        resource_name: str,
        export_devices_parameters: Union[_models.ExportDevicesRequest, IO],
        **kwargs: Any
    ) -> _models.JobResponse:
        """Exports all the device identities in the IoT hub identity registry to an Azure Storage blob
        container. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        Exports all the device identities in the IoT hub identity registry to an Azure Storage blob
        container. For more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param export_devices_parameters: The parameters that specify the export devices operation. Is
         either a ExportDevicesRequest type or a IO type. Required.
        :type export_devices_parameters:
         ~azure.mgmt.iothub.v2021_03_03_preview.models.ExportDevicesRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobResponse or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.JobResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.JobResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(export_devices_parameters, (IO, bytes)):
            _content = export_devices_parameters
        else:
            _json = self._serialize.body(export_devices_parameters, "ExportDevicesRequest")

        request = build_export_devices_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.export_devices.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("JobResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    export_devices.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/exportDevices"
    }

    @overload
    async def import_devices(
        self,
        resource_group_name: str,
        resource_name: str,
        import_devices_parameters: _models.ImportDevicesRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.JobResponse:
        """Import, update, or delete device identities in the IoT hub identity registry from a blob. For
        more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        Import, update, or delete device identities in the IoT hub identity registry from a blob. For
        more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param import_devices_parameters: The parameters that specify the import devices operation.
         Required.
        :type import_devices_parameters:
         ~azure.mgmt.iothub.v2021_03_03_preview.models.ImportDevicesRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobResponse or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.JobResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def import_devices(
        self,
        resource_group_name: str,
        resource_name: str,
        import_devices_parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.JobResponse:
        """Import, update, or delete device identities in the IoT hub identity registry from a blob. For
        more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        Import, update, or delete device identities in the IoT hub identity registry from a blob. For
        more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param import_devices_parameters: The parameters that specify the import devices operation.
         Required.
        :type import_devices_parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobResponse or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.JobResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def import_devices(
        self,
        resource_group_name: str,
        resource_name: str,
        import_devices_parameters: Union[_models.ImportDevicesRequest, IO],
        **kwargs: Any
    ) -> _models.JobResponse:
        """Import, update, or delete device identities in the IoT hub identity registry from a blob. For
        more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        Import, update, or delete device identities in the IoT hub identity registry from a blob. For
        more information, see:
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.

        :param resource_group_name: The name of the resource group that contains the IoT hub. Required.
        :type resource_group_name: str
        :param resource_name: The name of the IoT hub. Required.
        :type resource_name: str
        :param import_devices_parameters: The parameters that specify the import devices operation. Is
         either a ImportDevicesRequest type or a IO type. Required.
        :type import_devices_parameters:
         ~azure.mgmt.iothub.v2021_03_03_preview.models.ImportDevicesRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobResponse or the result of cls(response)
        :rtype: ~azure.mgmt.iothub.v2021_03_03_preview.models.JobResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-03-03-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-03-03-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.JobResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(import_devices_parameters, (IO, bytes)):
            _content = import_devices_parameters
        else:
            _json = self._serialize.body(import_devices_parameters, "ImportDevicesRequest")

        request = build_import_devices_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.import_devices.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorDetails, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("JobResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    import_devices.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/importDevices"
    }
