# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import MicrosoftElasticConfiguration
from .operations import Operations
from .operations import MonitorsOperations
from .operations import MonitoredResourcesOperations
from .operations import DeploymentInfoOperations
from .operations import TagRulesOperations
from .operations import VMHostOperations
from .operations import VMIngestionOperations
from .operations import VMCollectionOperations
from .. import models


class MicrosoftElastic(object):
    """MicrosoftElastic.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.elastic.aio.operations.Operations
    :ivar monitors: MonitorsOperations operations
    :vartype monitors: azure.mgmt.elastic.aio.operations.MonitorsOperations
    :ivar monitored_resources: MonitoredResourcesOperations operations
    :vartype monitored_resources: azure.mgmt.elastic.aio.operations.MonitoredResourcesOperations
    :ivar deployment_info: DeploymentInfoOperations operations
    :vartype deployment_info: azure.mgmt.elastic.aio.operations.DeploymentInfoOperations
    :ivar tag_rules: TagRulesOperations operations
    :vartype tag_rules: azure.mgmt.elastic.aio.operations.TagRulesOperations
    :ivar vm_host: VMHostOperations operations
    :vartype vm_host: azure.mgmt.elastic.aio.operations.VMHostOperations
    :ivar vm_ingestion: VMIngestionOperations operations
    :vartype vm_ingestion: azure.mgmt.elastic.aio.operations.VMIngestionOperations
    :ivar vm_collection: VMCollectionOperations operations
    :vartype vm_collection: azure.mgmt.elastic.aio.operations.VMCollectionOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = MicrosoftElasticConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.monitors = MonitorsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.monitored_resources = MonitoredResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.deployment_info = DeploymentInfoOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.tag_rules = TagRulesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vm_host = VMHostOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vm_ingestion = VMIngestionOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vm_collection = VMCollectionOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def _send_request(self, http_request: HttpRequest, **kwargs: Any) -> AsyncHttpResponse:
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.AsyncHttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = await self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "MicrosoftElastic":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
