# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserTokenParameters(Model):
    """Get User Token parameters.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. The Key to be used to generate token for user.
     Possible values include: 'primary', 'secondary'. Default value: "primary"
     .
    :type key_type: str or ~azure.mgmt.apimanagement.models.KeyType
    :param expiry: Required. The Expiry time of the Token. Maximum token
     expiry time is set to 30 days. The date conforms to the following format:
     `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
    :type expiry: datetime
    """

    _validation = {
        'key_type': {'required': True},
        'expiry': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'properties.keyType', 'type': 'KeyType'},
        'expiry': {'key': 'properties.expiry', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(UserTokenParameters, self).__init__(**kwargs)
        self.key_type = kwargs.get('key_type', "primary")
        self.expiry = kwargs.get('expiry', None)
