# example.js

``` javascript
function getTemplate(templateName) {
	return require("./templates/"+templateName);
}
console.log(getTemplate("a"));
console.log(getTemplate("b"));
```

# templates/

* a.js
* b.js
* c.js

All templates are of this pattern:

``` javascript
module.exports = function() {
	return "This text was generated by template X";
}
```

# js/output.js

<details><summary><code>/******/ (function(modules) { /* webpackBootstrap */ })</code></summary>

``` javascript
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "js/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 3);
/******/ })
/************************************************************************/
```

</details>

``` javascript
/******/ ([
/* 0 */
/*!************************!*\
  !*** ./templates/a.js ***!
  \************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function() {
	return "This text was generated by template A";
}

/***/ }),
/* 1 */
/*!************************!*\
  !*** ./templates/b.js ***!
  \************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function() {
	return "This text was generated by template B";
}

/***/ }),
/* 2 */
/*!************************!*\
  !*** ./templates/c.js ***!
  \************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function() {
	return "This text was generated by template C";
}

/***/ }),
/* 3 */
/*!********************!*\
  !*** ./example.js ***!
  \********************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

function getTemplate(templateName) {
	return __webpack_require__(/*! ./templates */ 4)("./"+templateName);
}
console.log(getTemplate("a"));
console.log(getTemplate("b"));

/***/ }),
/* 4 */
/*!****************************!*\
  !*** ./templates ^\.\/.*$ ***!
  \****************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./a": 0,
	"./a.js": 0,
	"./b": 1,
	"./b.js": 1,
	"./c": 2,
	"./c.js": 2
};
function webpackContext(req) {
	return __webpack_require__(webpackContextResolve(req));
};
function webpackContextResolve(req) {
	var id = map[req];
	if(!(id + 1)) // check for number or string
		throw new Error("Cannot find module '" + req + "'.");
	return id;
};
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = 4;

/***/ })
/******/ ]);
```

# Info

## Uncompressed

```
Hash: acf02a400c4d02cc105a
Version: webpack 3.5.1
    Asset     Size  Chunks             Chunk Names
output.js  4.42 kB       0  [emitted]  main
Entrypoint main = output.js
chunk    {0} output.js (main) 613 bytes [entry] [rendered]
    > main [3] ./example.js 
    [0] ./templates/a.js 82 bytes {0} [optional] [built]
        context element ./a.js [4] ./templates ^\.\/.*$ ./a.js
        context element ./a [4] ./templates ^\.\/.*$ ./a
    [1] ./templates/b.js 82 bytes {0} [optional] [built]
        context element ./b.js [4] ./templates ^\.\/.*$ ./b.js
        context element ./b [4] ./templates ^\.\/.*$ ./b
    [2] ./templates/c.js 82 bytes {0} [optional] [built]
        context element ./c.js [4] ./templates ^\.\/.*$ ./c.js
        context element ./c [4] ./templates ^\.\/.*$ ./c
    [3] ./example.js 150 bytes {0} [built]
    [4] ./templates ^\.\/.*$ 217 bytes {0} [built]
        cjs require context ./templates [3] ./example.js 2:8-44
```

## Minimized (uglify-js, no zip)

```
Hash: acf02a400c4d02cc105a
Version: webpack 3.5.1
    Asset     Size  Chunks             Chunk Names
output.js  1.08 kB       0  [emitted]  main
Entrypoint main = output.js
chunk    {0} output.js (main) 613 bytes [entry] [rendered]
    > main [3] ./example.js 
    [0] ./templates/a.js 82 bytes {0} [optional] [built]
        context element ./a.js [4] ./templates ^\.\/.*$ ./a.js
        context element ./a [4] ./templates ^\.\/.*$ ./a
    [1] ./templates/b.js 82 bytes {0} [optional] [built]
        context element ./b.js [4] ./templates ^\.\/.*$ ./b.js
        context element ./b [4] ./templates ^\.\/.*$ ./b
    [2] ./templates/c.js 82 bytes {0} [optional] [built]
        context element ./c.js [4] ./templates ^\.\/.*$ ./c.js
        context element ./c [4] ./templates ^\.\/.*$ ./c
    [3] ./example.js 150 bytes {0} [built]
    [4] ./templates ^\.\/.*$ 217 bytes {0} [built]
        cjs require context ./templates [3] ./example.js 2:8-44
```

# Code Splitting

See [this example combined with code splitting](../code-splitted-require.context)
