/**
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var isCollection = require( '@stdlib/assert/is-collection' );


// MAIN //

/**
* Returns an array of iterated values.
*
* @private
* @param {Object} it - iterator
* @returns {(Array|TypeError)} array or an error
*/
function fromIterator( it ) {
	var out;
	var v;
	var z;

	out = [];
	while ( true ) {
		v = it.next();
		z = v.value;
		if ( z ) {
			if ( !isCollection( z ) ) {
				return new TypeError( 'invalid argument. An iterator must return an array-like object containing vertices. Value: `'+z+'`.' );
			}
			out.push( z[ 0 ], z[ 1 ] );
		}
		if ( v.done ) {
			break;
		}
	}
	return out;
}


// EXPORTS //

module.exports = fromIterator;
