/*
This code is derived from jgit (http://eclipse.org/jgit).
Copyright owners are documented in jgit's IP log.

This program and the accompanying materials are made available
under the terms of the Eclipse Distribution License v1.0 which
accompanies this distribution, is reproduced below, and is
available at http://www.eclipse.org/org/documents/edl-v10.php

All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

- Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.

- Neither the name of the Eclipse Foundation, Inc. nor the
  names of its contributors may be used to endorse or promote
  products derived from this software without specific prior
  written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using NGit.Storage.Pack;
using NGit.Transport;
using Sharpen;

namespace NGit.Transport
{
	/// <summary>
	/// Logs activity that occurred within
	/// <see cref="UploadPack">UploadPack</see>
	/// .
	/// <p>
	/// Implementors of the interface are responsible for associating the current
	/// thread to a particular connection, if they need to also include connection
	/// information. One method is to use a
	/// <see cref="Sharpen.ThreadLocal{T}">Sharpen.ThreadLocal&lt;T&gt;</see>
	/// to remember
	/// the connection information before invoking UploadPack.
	/// </summary>
	public abstract class UploadPackLogger
	{
		private sealed class _UploadPackLogger_58 : UploadPackLogger
		{
			public _UploadPackLogger_58()
			{
			}

			public override void OnPackStatistics(PackWriter.Statistics stats)
			{
			}
		}

		/// <summary>A simple no-op logger.</summary>
		/// <remarks>A simple no-op logger.</remarks>
		public static UploadPackLogger NULL = new _UploadPackLogger_58();

		// Do nothing.
		/// <summary>Notice to the logger after a pack has been sent.</summary>
		/// <remarks>Notice to the logger after a pack has been sent.</remarks>
		/// <param name="stats">the statistics after sending a pack to the client.</param>
		public abstract void OnPackStatistics(PackWriter.Statistics stats);
	}
}
