# Sponsoring FAQs

Do you have questions about Material for MkDocs Insiders? We do our best to
answer all of your questions on this page. If you can't find your question 
below, ask it on our [discussion board]!

  [discussion board]: https://github.com/squidfunk/mkdocs-material/discussions/new/chooses

## General	

[__Why is the Insiders edition offered as a subscription model?__](#insiders-subscription){ #insiders-subscription }

Material for MkDocs always was and will be Open Source, available for free to
individuals and organizations. As the project grew over time, we found that
maintaining and managing the overhead that comes with growth became more
challenging and time-consuming.

In order to sustain the project and add new and useful features more frequently,
we decided to create the [Insiders] edition, with early access to the latest and
greatest features of Material for MkDocs. The subscription-based model of the
Insiders edition allows us to dedicate more time and resources to the project,
which benefits all 
users of Material for MkDocs. Once our funding goals based on monthly 
subscriptions are hit, the Insiders features of those^ funding goals are released 
to the community edition, letting everyone benefit from them. 

Maintaining both the community and Insiders editions is an ongoing process, and 
we rely on our sponsors to support us on a monthly basis, which makes this whole 
project possible.

[__What features are included in the Insiders edition?__](#insiders-features){ #insiders-features }

The Insiders edition includes more than 20 additional features. You can find an 
overview of these features on our [Insiders page], which is updated when new
features are added and released.

  [Insiders]: ../insiders/index.md
  [Insiders page]: ../insiders/index.md#whats-in-it-for-me

[__How often is the Insiders edition updated?__](#insiders-updates){ #insiders-updates }

We try to keep our open issue count low, fixing known bugs quickly. Both our
repositories, the community and Insiders edition, are constantly updated with
bug fixes and new features.

## Sponsorship	

[__Can I sponsor the project without a GitHub account?__](#sponsorship-account){ #sponsorship-account }

Yes. You can support Material for MkDocs by sponsoring us on [Ko-fi], regardless
of whether you have a GitHub account or not. However, please note that Insiders
is provided as a private repository on GitHub. If after sponsoring, you'd like to
gain access to the repository, you'll need to have a GitHub individual or bot
account that can be added as a collaborator. If your organization doesn't use
GitHub or/and host its repositories on other platforms, you can mirror the
Insiders repository in your environment once you have access.

[__Which sponsoring tier should I choose?__](#sponsorship-tier){ #sponsorship-tier }

The sponsoring tiers are divided into non-commercial and commercial tiers. If 
you are an individual or organization using Material for MkDocs for private or
__non-commercial__ Open Source projects, you have two tiers to choose from, 
depending on the number of sites you want to build. For companies using 
Material for MkDocs, we offer three different __commercial__ tiers, from which 
you can choose depending on your requirements.

Also, please read what is considered [commercial use].

  [commercial use]: #commercial-use

[__Why are one-time sponsorships not granted access to Insiders?__](#sponsorship-one-time){ #sponsorship-one-time }

Primarily due to technical reasons, that we're working on lifting in the future.
We use GitHub webhooks to determine our current active sponsors. When you create
or cancel your monthly subscription, GitHub sends events that we use to
automatically add and remove collaborators.

Note that [$15] is the minimum amount to be granted access to Insiders.

  [$15]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=210638

[__How are sponsorship contributions used?__](#sponsorship-support){ #sponsorship-support }

It's vital to recognize that the total sponsorship amount doesn't directly
translate into the funds we have available for use. The way we allocate
sponsorship amounts is detailed as follows:

1.  __Taxes__: Since we provide a service to our sponsors, we're of course
    legally obligated to pay sales tax. This requirement applies to all
    sponsorship contributions, aligning us with standard business practices
    as for the rest of the world.

2.  __Sponsorships__: A significant portion of our funding is redirected to
    upstream projects. This cultivates collaboration and supports the broader
    Open Source ecosystem. Those projects and their maintainers are essential
    for the ongoing development of Material for MkDocs.

    [Explore our sponsorships](https://github.com/squidfunk?tab=sponsoring).

3.  __Funds__: We are in the process of forming a team devoted to Material for
    MkDocs and are proactively compensating critical contributors. These
    funds cover various aspects of the project, like the creation of new
    features, bug resolution, support, and sponsor relations.

[__Are there any limitations on the number of sponsors for a particular tier?__](#sponsorship-limitations){ #sponsorship-limitations }

No, there are no limitations on the number of sponsors for any tier. You can
sponsor the project at any tier regardless of how many other sponsors are
already there.

## Payment & billing	

[__Is there a trial period for the Insiders edition?__](#insiders-trial){ #insiders-trial }

No, we do not offer a trial period for the Insiders edition. However, if you're
a company and are considering sponsoring on the commercial tier, but want to
first give the Insiders edition a try, you can sponsor on the [$15] tier with a
personal account for non-commercial evaluation purposes.

Additionally, our subscription model allows you to cancel your sponsorship
anytime. If you decide to cancel, your sponsorship will remain active until 
the end of your billing cycle.

[__What payment options do you accept?__](#insiders-payment){ #insiders-payment }

We manage all our transactions and sponsorships through [GitHub Sponsors] and 
[Ko-fi]. To become a sponsor of Material for MkDocs on GitHub, visit 
[our sponsors' page]. On there, you can choose from five different sponsorship 
tiers and pay by credit card. Please note that as of the beginning of 2023, 
[GitHub no longer supports PayPal] payments. If you wish to pay with PayPal, 
you can find a selection of our sponsorship tiers on [Ko-fi]. Both platforms
provide you with a payment receipt once your purchase is successful.

If you're a company and need assistance choosing the right payment method,
please don't hesitate to reach out to sponsors@squidfunk.com.

  [Ko-fi]: https://ko-fi.com/squidfunk
  [GitHub Sponsors]: https://github.com/sponsors
  [GitHub no longer supports PayPal]: https://github.blog/changelog/2023-01-23-github-sponsors-will-stop-supporting-paypal/
  [our sponsors' page]: https://github.com/sponsors/squidfunk/

[__Are discounts available for the Insiders edition, such as student discounts?__](#insiders-discounts){ #insiders-discounts }

Unfortunately, we are not able to offer any discounts for the Material for 
MkDocs Insiders program. To ensure that everyone can afford the Insiders program 
and keep the barrier as low as possible, we have set prices as low as [$15] a
month for non-commercial use.

[__Do you offer free access to Insiders for Open Source projects?__](#insiders-open-source){ #insiders-open-source }

No, we do not offer free access to our Material for MkDocs Insiders edition. 
We understand that non-profit organizations may have limited budgets and may 
need to prioritize their spending on other projects or organizations. However,
it's important to note that Material for MkDocs is maintained by a small team, 
investing a lot of time and resources into constantly improving this project. 
Material for MkDocs and its core features are free to the community through our 
Open Source model. Therefore, Material for MkDocs itself is already free.

However, we do offer an affordable sponsorship tier starting at [$15] a month, 
which is meant for individuals and non-profit organizations using Material for 
MkDocs to build 1-2 sites for non-commercial purposes. This tier provides access 
to all new features, benefiting you from our ongoing development efforts.

[__Is Insiders free for those who contribute to this project?__](#insiders-contributors){ #insiders-contributors }

Great question! We can not offer free access to "drive-by" contributors that 
only fix minor issues like typos or add new languages. These contributions are 
always welcome, but as we need to review them, they result in a higher time 
investment from our side and don't compensate for this work. However, as this 
project keeps growing, we always seek for individuals to support us. In return, 
we offer financial compensation or/and Insiders access. If you are interested 
and have experience in the technologies and paradigms listed below, please get
in touch with us at sponsors@squidfunk.com:

- Deep knowledge of CSS, HTML, TypeScript
- Experience with progressive enhancement and responsive design
- Experience with reactive programming with RxJS
- Solid understanding of Python, MkDocs + ecosystem
- Solid technical writing skills

Additionally, we're working on a contributor program that will reward
contributors that engage in the community by answering questions and helping
users with access to Insiders.

[__How can I set my billing to monthly or yearly?__](#insiders-billing-cycle){ #insiders-billing-cycle }

You can sponsor Material for MkDocs on a monthly or yearly basis. Depending on 
your billing cycle you automatically become a monthly or yearly sponsor. Your 
[billing cycle] is an account-level setting that you can easily change in your 
account. If, for some reason, you cannot make this change, you can create a 
dedicated bot account with a yearly billing cycle on GitHub, which you only use 
for sponsoring (some sponsors already do that). If you have any problems or 
further questions, please contact us at sponsors@squidfunk.com.

  [billing cycle]: https://docs.github.com/en/github/setting-up-and-managing-billing-and-payments-on-github/changing-the-duration-of-your-billing-cycle

[__Can I get an invoice for my sponsorship payment?__](#insiders-invoice){ #insiders-invoice}

Right now, we can't provide you with an invoice for your sponsoring transaction,
as [GitHub Sponsors] handles all transactions for us. However, both payment
platforms, [GitHub] and [Ko-Fi], automatically send you a payment receipt 
via mail once the sponsorship is active.

Furthermore, we are working on a solution to optimize access management and more
features. If you are interested in this, please get in touch with us via mail at
sponsors@squidfunk.com or turn on all notifications for MkDocs, and we will
reach out as soon as we are live.

  [GitHub]: https://github.com/sponsors/squidfunk/

[__Can I switch between different sponsoring tiers?__](#insiders-switch-tiers){ #insiders-switch-tiers }

Yes, you can switch between different sponsoring tiers at any time. Simply go 
to the [GitHub Sponsors] page and change your sponsoring tier. Once you make 
that change, you will immediately change to the new tier.

If you change to a higher tier, the amount will be prorated according to your
billing cycle.

[__Can I sponsor the project for a specific feature or development goal?__](#insiders-goals){ #insiders-goals }

While sponsoring specific goals directly is not possible, our sponsoring goals
are connected to specific features or development goals aligned with the 
project's roadmap. You can find an [overview of these sponsoring goals] and their 
associated features on our website. Insider users have early access to all 
already developed features, including those associated with higher funding goals 
that will be reached at a later stage. If you're interested in accessing these 
features, becoming a sponsor is the way to go. If you have a feature in mind 
that you would like to see on the list, we encourage you to 
[initiate a new discussion] to evaluate it with others.

  [overview of these sponsoring goals]: ../insiders/index.md#goals
  [initiate a new discussion]: https://github.com/squidfunk/mkdocs-material/discussions/new/chooses

[__What happens if I reach my sponsoring limit for my current tier?__](#insiders-limit){ #insiders-limit }

If you extend the number of sites that are in your current sponsoring limit, 
please [upgrade your sponsorship] to a higher tier to continue using the 
Insiders version and build more sites. The change will be effective immediately.

  [upgrade your sponsorship]: https://docs.github.com/en/billing/managing-billing-for-github-sponsors/upgrading-a-sponsorship

[__Do you offer refunds for sponsoring payments?__](#insiders-refunds){ #insiders-refunds }

Unfortunately, we cannot offer any refund for sponsorship payments. 
[GitHub Sponsors] and [Ko-Fi] manage all sponsoring transactions. Because of 
that, we do not have any insights into the details of the funds and cannot access 
them. If you have any payment issues, please get in touch with the GitHub 
or Ko-Fi support team, as they can help you.

## Access management	

[__How do I gain access to the private Insiders repository?__](#access-account){ #access-account }

If you sponsored with your __individual account__, you should have received an 
email invitation to the private Material for MkDocs Insiders repository right 
after you initiated your sponsorship. Simply accept the invitation within seven 
days to gain access.

If you sponsored using an __organization account__, please note we need 
an individual account that we can list as a collaborator of the private Insiders 
repository. After you initiate your sponsorship, please email us at 
sponsors@squidfunk.com with the name of the individual or bot account. Once you 
provide us with this information, we will add the account as a collaborator, and 
after you accept the invitation, you will gain access to the repository.

If you have yet to receive the email or the invitation link has expired, please 
contact us, the maintainers, at sponsors@squidfunk.com. We're working on a
solution that will allow you to manage collaborator status yourself.

[__Why can't our whole organization get access to Insiders?__](#access-organization){ #access-organization }

Currently, it is not possible to grant access to an organizational account, as 
GitHub only allows for adding individual user accounts. We are working on a 
solution ourselves to simplify access for organizations. For now, to ensure that 
access is not tied to a particular individual, we recommend creating a bot 
account, i.e., a GitHub account that does not belong to a specific individual 
but is listed as the owner of the organizational account and using this account 
for sponsorship.

[__Do I need to fork the repository to use it?__](#access-fork){ #access-fork }

It depends. If you are using the Insiders edition as an individual, you can work
directly with the private repository, as you do not need to share the Insiders
features with others. If you are working with a team, it is best to create a
private fork using the individual account you listed as a collaborator of
Material for MkDocs to grant access to all members of your organization to
your fork.

[__Can I share my Insiders access with others?__](#access-share){ #access-share }

At the moment, it is not possible to directly share your collaborator status 
for the private Insiders repository with other accounts. However, if you are 
working with a team and would like them to access Insiders, you can share the 
Insiders repository by utilizing options such as [cloning], [forking], or 
[mirroring]. By doing so, you can start collaborating with your team members on 
the new repository you have shared. This way, you can collectively benefit 
from the Insiders features and work together on the project.

  [cloning]: https://docs.github.com/en/repositories/creating-and-managing-repositories/cloning-a-repository
  [forking]: https://docs.github.com/en/get-started/quickstart/fork-a-repo
  [mirroring]: https://docs.github.com/en/repositories/creating-and-managing-repositories/duplicating-a-repository


## Runtime & cancellation	

[__How long is my sponsorship valid?__](#sponsorship-runtime){ #sponsorship-runtime }

Your sponsorship is valid for as long as your monthly or yearly subscription
is valid. If you choose to cancel your sponsorship, you will lose access to 
the Insiders edition once your cancelation is active and will be automatically 
removed by GitHub as a collaborator from the private repository. 

[__How do I cancel my sponsorship?__](#sponsorship-cancellation){ #sponsorship-cancellation }

To cancel your sponsorship, follow the [step-by-step guide] provided by GitHub. 
If you sponsored using an organizational account, please ensure that you cancel 
your sponsorship using the same organizational account rather than your 
individual account.

  [step-by-step guide]: https://docs.github.com/en/billing/managing-billing-for-github-sponsors/downgrading-a-sponsorship

[__What happens when I cancel my sponsorship?__](#sponsorship-cancellation-effective){ #sponsorship-cancellation-effective }

If you choose to cancel your subscription to Insiders, you will be 
automatically removed by GitHub as a collaborator on the day your cancellation is 
effective. From that day on, you will no longer receive future updates. However, 
you are __welcome to continue using the latest version__ that was available to 
you at the time of your cancellation for as long as you like.

Please note that [GitHub deletes private forks], so you may want to take steps to ensure
that you have a backup of the software if necessary and use the locally installed version.

  [GitHub deletes private forks]: https://docs.github.com/en/account-and-profile/setting-up-and-managing-your-personal-account-on-github/managing-access-to-your-personal-repositories/removing-a-collaborator-from-a-personal-repository#deleting-forks-of-private-repositories

## Licensing	

[__What constitutes commercial use of the Insiders version?__](#commercial-use){ #commercial-use }

Commercial use refers to any use of the software for a business or for-profit 
purpose. This includes any use by a corporation or other organization, whether 
or not they generate revenue directly from the software. We offer different 
pricing tiers for commercial use, each tailored to the needs of different 
businesses. It's important to note that internal use of the software within your 
organization is also considered commercial use, as with all commercial software.

[__What constitutes non-commercial use of the Insiders version?__](#non-commercial-use){ #non-commercial-use }

Non-commercial use of our Material for MkDocs refers to private use. This
includes individuals using the Insiders edition for private or purely
non-commercial Open Source projects. We offer two different tiers for
non-commercial use, depending on the number of sites you want to build.  

[__What is your fair use policy?__](#fair-use-policy){ #fair-use-policy }

Our fair use policy includes the following guidelines:

- Please refrain from __distributing the source code__ of Insiders. While you 
may use the software for public, private, or commercial projects and may 
privately fork or mirror it, we ask that you keep the source code private. This 
is important to our sponsorware strategy, which helps us fund ongoing 
development and support of the software. If this guidelines is violated,
everybody loses, as it will reduce the time of us maintainers we can set aside
to push this project forward.

- As our sponsoring tiers are based on the number of sites you want to build, 
please make sure to [upgrade your sponsorship] once your current sponsoring tier 
limit has been reached. 

[__Does the Insiders version have a different license?__](#insiders-license){ #insiders-license }

No. Whether you're an individual or a company, you may use Material for 
MkDocs Insiders precisely under the same terms as Material for MkDocs, which are 
given by the [MIT license].

[MIT license]: ../license.md

[__Can outside collaborators build and run the documentation locally without access to Insiders?__](#insiders-outside-collaborators){ #insiders-outside-collaborators }

Yes. Insiders is compatible with Material for MkDocs. Almost all new features
and configuration options are either backward-compatible or implemented behind
feature flags. When working with outside collaborators, changing the general 
appearance of your site should be optional. Most Insiders features enhance the 
overall experience, e.g., by adding icons to pages or providing a feedback 
widget. While these features add value for your site's users, they should be 
optional for previewing when making changes to content. Currently, the only 
content-related feature in Insiders that non-Insiders users can't properly 
preview are [Card grids].

This means that outside collaborators can build the documentation locally with 
Material for MkDocs, and when they push their changes, your CI pipeline will 
build it with Insiders. When using built-in plugins exclusive to Insiders, it's 
recommended to split configuration into a base `mkdocs.yml` and one with plugin 
overrides via [configuration inheritance].

See the [getting started guide] for more information.

  [configuration inheritance]: https://www.mkdocs.org/user-guide/configuration/#configuration-inheritance
  [getting started guide]: ../insiders/getting-started.md#caveats
  [Card grids]: ../reference/grids.md?h=grids#using-card-grids

## Support	

[__How can I contact support if I have questions about becoming a sponsor?__ ](#support-contact){ #support-contact }

If you have any questions and would like to contact us before starting your 
sponsorship, we are happy to answer all your non-technical questions about the 
Insiders program via email at sponsors@squidfunk.com.

All technical questions should be asked openly on our [discussion board].

  [discussion board]: https://github.com/squidfunk/mkdocs-material/discussions

[__Is additional support available for Material for MkDocs Insiders users?__](#support-additional){ #support-additional }

Yes, we provide non-technical support related to sponsoring at
sponsors@squidfunk.com. For technical questions, please submit an issue openly 
on our [issue tracker] or start a discussion on our [discussion board]. Issues 
and discussions from our organizational sponsors, sponsoring on 
__The Organization__ tier or higher will be prioritized.[^1]

  [^1]:
    Priority support means we will prioritize your issue, meaning we will look 
    into it and do our best to solve your issue asap. However, the prioritized bug 
    support does not mean that we can solve your issue before any others since 
    some issues might take more time to solve.

  [issue tracker]: https://github.com/squidfunk/mkdocs-material/issues

[__How can I display my logo on the list of premium sponsors?__](#sponsorship-logo-placement){ #sponsorship-logo-placement }

If your sponsorship tier includes logo placement, and you would like us to
display your logo in the [list of premium sponsors] and have it linked to your
site, please contact us via mail. Simply send us a horizontal SVG or PNG version
of your logo making sure it displays the name of your company and the logo to
sponsors@squidfunk.com. 

  [list of premium sponsors]: https://github.com/squidfunk/mkdocs-material#user-content-premium-sponsors

[__Is logo placement optional?__](#sponsorship-logo-placement-optional){ #sponsorship-logo-placement-optional }

Yes, all of our commercial benefits, such as logo placement and backlinks, are 
optional and can be opted in or out at any time. You can keep your sponsorship
completely private.

[__How can I report a bug in the Insiders version?__](#insiders-bugs){ #insiders-bugs }

If you encounter a bug in the Insiders edition, we kindly request that you 
report it on our [issue tracker] in the public community repository. When 
submitting the bug report, please ensure that you do not include any private 
Insiders' source code, as we want to uphold our fair use policy. 


## Privacy	

[__Will you sign an NDA for sponsorships?__](#nda){ #nda }

Unfortunately, we cannot sign any NDA or vendor agreement form. As a small team
working on Material for MkDocs, we have limited resources and cannot review 
and sign agreements.

[__Can I sponsor privately?__](#sponsorship-private){ #sponsorship-private }

Yes, you can. GitHub gives you the option to set your sponsorship to [private] 
when you set up your sponsorship. Additionally, we have a recommended workflow 
for you: We suggest you create a new GitHub bot account. This bot account should 
not be tied to a particular individual and should be privately listed as an 
owner of your GitHub organization. This account can then be used to sponsor 
Material for MkDocs privately. As a bot account, it will automatically be listed 
as a collaborator of the private Insiders repository. You can clone, fork, or 
mirror using this account. All information will be kept confidential; only the 
bot account and us maintainers will have insights into his sponsorship. 

  [private]: https://docs.github.com/en/sponsors/sponsoring-open-source-contributors/managing-your-sponsorship#managing-the-privacy-setting-for-your-sponsorship

[__Are there any geographical restrictions on becoming a sponsor?__](#sponsorship-geo){ #sponsorship-geo }

No, there are no geographical restrictions for becoming a sponsor. We welcome 
sponsorships from individuals and organizations worldwide. As long as your 
credit card is valid and accepted by GitHub or Ko-Fi, you are eligible to become 
a sponsor and support the project, regardless of your location. 
