/*
  This file was generated automatically with ./scripts/maple2c.pl.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_k_tflw.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


static inline void
func_unpol(const xc_func_type *p, int order, const double *rho, const double *sigma , double *zk GGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t24, t25, t26, t28, t31, t33, t34, t35;
  double t36, t40, t44;

#ifndef XC_DONT_COMPILE_VXC
  double t50, t53, t56, t60, t68, t71;

#ifndef XC_DONT_COMPILE_FXC
  double t80, t83, t87, t92;

#ifndef XC_DONT_COMPILE_KXC
  double t105, t109, t115;

#ifndef XC_DONT_COMPILE_LXC
  double t132, t138;
#endif

#endif

#endif

#endif

#endif


  gga_k_tflw_params *params;

  assert(p->params != NULL);
  params = (gga_k_tflw_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t24 = params->lambda * sigma[0];
  t25 = M_CBRT2;
  t26 = t25 * t25;
  t28 = rho[0] * rho[0];
  t31 = M_CBRT6;
  t33 = M_PI * M_PI;
  t34 = POW_1_3(t33);
  t35 = t34 * t34;
  t36 = 0.1e1 / t35;
  t40 = params->gamma + 0.5e1 / 0.72e2 * t24 * t26 / t22 / t28 * t31 * t36;
  t44 = my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t20 * t22 * t40);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = 0.2e1 * t44;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t50 = t28 * rho[0];
  t53 = t7 * t20 / t50;
  t56 = t24 * t26 * t31 * t36;
  t60 = my_piecewise3(t2, 0, t7 * t20 / t21 * t40 / 0.10e2 - t53 * t56 / 0.36e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = 0.2e1 * rho[0] * t60 + 0.2e1 * t44;

  t68 = params->lambda * t26 * t31 * t36;
  t71 = my_piecewise3(t2, 0, t7 * t20 / t28 * t68 / 0.96e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.2e1 * rho[0] * t71;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t80 = t28 * t28;
  t83 = t7 * t20 / t80;
  t87 = my_piecewise3(t2, 0, -t7 * t20 / t21 / rho[0] * t40 / 0.30e2 + 0.7e1 / 0.108e3 * t83 * t56);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * rho[0] * t87 + 0.4e1 * t60;

  t92 = my_piecewise3(t2, 0, -t53 * t68 / 0.48e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.2e1 * rho[0] * t92 + 0.2e1 * t71;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t105 = t7 * t20 / t80 / rho[0];
  t109 = my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t20 / t21 / t28 * t40 - 0.41e2 / 0.162e3 * t105 * t56);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.2e1 * rho[0] * t109 + 0.6e1 * t87;

  t115 = my_piecewise3(t2, 0, t83 * t68 / 0.16e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.2e1 * rho[0] * t115 + 0.4e1 * t92;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t132 = my_piecewise3(t2, 0, -0.14e2 / 0.135e3 * t7 * t20 / t21 / t50 * t40 + 0.611e3 / 0.486e3 * t7 * t20 / t80 / t28 * t56);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.2e1 * rho[0] * t132 + 0.8e1 * t109;

  t138 = my_piecewise3(t2, 0, -t105 * t68 / 0.4e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.2e1 * rho[0] * t138 + 0.6e1 * t115;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}


static inline void
func_pol(const xc_func_type *p, int order, const double *rho, const double *sigma , double *zk GGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t33, t34, t35, t37, t38, t40, t41;
  double t42, t43, t47, t51, t52, t53, t55, t56;
  double t57, t58, t59, t61, t62, t63, t64, t65;
  double t66, t68, t73, t77;

#ifndef XC_DONT_COMPILE_VXC
  double t78, t79, t80, t82, t85, t86, t90, t91;
  double t94, t95, t98, t101, t105, t106, t108, t111;
  double t112, t116, t119, t121, t125, t128, t129, t134;
  double t136, t139, t140, t144, t147, t150, t154, t158;
  double t159, t162, t164, t167;

#ifndef XC_DONT_COMPILE_FXC
  double t170, t171, t174, t175, t176, t179, t183, t184;
  double t188, t190, t192, t196, t197, t200, t201, t202;
  double t204, t206, t209, t213, t214, t215, t218, t221;
  double t225, t226, t230, t232, t234, t237, t239, t242;
  double t246, t250, t251, t255, t257, t259, t265, t266;
  double t270, t274, t275, t279, t281, t284, t287, t288;
  double t291, t296, t301, t305, t306, t312, t313, t318;
  double t322, t323, t328, t332, t334, t337, t341, t347;
  double t349, t353, t358, t360, t365, t370, t374;

#ifndef XC_DONT_COMPILE_KXC
  double t379, t380, t383, t386, t387, t388, t391, t395;
  double t396, t400, t402, t404, t407, t409, t411, t412;
  double t417, t418, t421, t422, t423, t425, t429, t432;
  double t436, t438, t439, t442, t445, t448, t452, t453;
  double t457, t459, t461, t463, t465, t468, t470, t473;
  double t474, t475, t478, t483, t484, t486, t490, t491;
  double t495, t498, t499, t502, t504, t506, t508, t516;
  double t517, t518, t521, t526, t528, t532, t533, t537;
  double t540, t541, t543, t547, t550, t552, t553, t554;
  double t557, t560, t565, t569, t573, t574, t578, t580;
  double t582, t589, t590, t595, t599, t603, t604, t608;
  double t610, t613, t616, t617, t623, t625, t626, t631;
  double t638, t642, t643, t650, t651, t658, t662, t663;
  double t668, t679, t682, t686, t692, t697, t698, t701;
  double t705, t710, t713, t715, t719, t726, t730, t735;
  double t738, t745, t755, t759;

#ifndef XC_DONT_COMPILE_LXC
  double t765, t769, t773, t776, t780, t781, t783, t784;
  double t790, t796, t797, t800, t804, t811, t813, t825;
  double t827, t830, t831, t833, t834, t836, t837, t839;
  double t840, t841, t843, t844, t850, t855, t858, t862;
  double t869, t873, t877, t882, t884, t891, t895, t896;
  double t899, t920, t921, t923, t927, t934, t944, t947;
  double t948, t950, t951, t952, t953, t954, t971, t973;
  double t977, t984, t988, t989, t992, t997, t1000, t1001;
  double t1003, t1004, t1005, t1006, t1007, t1009, t1010, t1019;
  double t1026, t1038, t1051, t1055, t1068, t1071, t1072, t1074;
  double t1075, t1084, t1097, t1101, t1108, t1112, t1117, t1120;
  double t1121, t1123, t1124, t1133, t1135, t1137, t1138, t1159;
  double t1163, t1170, t1172, t1181, t1182, t1199, t1203, t1210;
  double t1214, t1217, t1218, t1225, t1233, t1235, t1236, t1241;
  double t1246, t1253, t1257, t1266, t1267, t1272, t1279, t1283;
  double t1309, t1312, t1313, t1319, t1323, t1325, t1330, t1331;
  double t1333, t1340, t1345, t1347, t1350, t1352, t1354, t1358;
  double t1361, t1364, t1372, t1373, t1375, t1379, t1380, t1387;
  double t1388, t1391, t1395, t1403, t1407, t1412, t1418, t1420;
  double t1421, t1429, t1448;
#endif

#endif

#endif

#endif

#endif


  gga_k_tflw_params *params;

  assert(p->params != NULL);
  params = (gga_k_tflw_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = params->lambda * sigma[0];
  t33 = rho[0] * rho[0];
  t34 = POW_1_3(rho[0]);
  t35 = t34 * t34;
  t37 = 0.1e1 / t35 / t33;
  t38 = M_CBRT6;
  t40 = M_PI * M_PI;
  t41 = POW_1_3(t40);
  t42 = t41 * t41;
  t43 = 0.1e1 / t42;
  t47 = params->gamma + 0.5e1 / 0.72e2 * t32 * t37 * t38 * t43;
  t51 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t31 * t47);
  t52 = rho[1] <= p->dens_threshold;
  t53 = -t17;
  t55 = my_piecewise5(t15, t12, t11, t16, t53 * t8);
  t56 = 0.1e1 + t55;
  t57 = t56 <= p->zeta_threshold;
  t58 = POW_1_3(t56);
  t59 = t58 * t58;
  t61 = my_piecewise3(t57, t24, t59 * t56);
  t62 = t61 * t30;
  t63 = params->lambda * sigma[2];
  t64 = rho[1] * rho[1];
  t65 = POW_1_3(rho[1]);
  t66 = t65 * t65;
  t68 = 0.1e1 / t66 / t64;
  t73 = params->gamma + 0.5e1 / 0.72e2 * t63 * t68 * t38 * t43;
  t77 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t62 * t73);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = t51 + t77;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t78 = t7 * t7;
  t79 = 0.1e1 / t78;
  t80 = t17 * t79;
  t82 = my_piecewise5(t11, 0, t15, 0, t8 - t80);
  t85 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t82);
  t86 = t85 * t30;
  t90 = 0.1e1 / t29;
  t91 = t28 * t90;
  t94 = t6 * t91 * t47 / 0.10e2;
  t95 = t6 * t31;
  t98 = 0.1e1 / t35 / t33 / rho[0];
  t101 = t32 * t98 * t38 * t43;
  t105 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t86 * t47 + t94 - t95 * t101 / 0.36e2);
  t106 = t53 * t79;
  t108 = my_piecewise5(t15, 0, t11, 0, -t8 - t106);
  t111 = my_piecewise3(t57, 0, 0.5e1 / 0.3e1 * t59 * t108);
  t112 = t111 * t30;
  t116 = t61 * t90;
  t119 = t6 * t116 * t73 / 0.10e2;
  t121 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t112 * t73 + t119);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = t51 + t77 + t7 * (t105 + t121);

  t125 = my_piecewise5(t11, 0, t15, 0, -t8 - t80);
  t128 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t125);
  t129 = t128 * t30;
  t134 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t129 * t47 + t94);
  t136 = my_piecewise5(t15, 0, t11, 0, t8 - t106);
  t139 = my_piecewise3(t57, 0, 0.5e1 / 0.3e1 * t59 * t136);
  t140 = t139 * t30;
  t144 = t6 * t62;
  t147 = 0.1e1 / t66 / t64 / rho[1];
  t150 = t63 * t147 * t38 * t43;
  t154 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t140 * t73 + t119 - t144 * t150 / 0.36e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[1] = t51 + t77 + t7 * (t134 + t154);

  t158 = t38 * t43;
  t159 = params->lambda * t37 * t158;
  t162 = my_piecewise3(t1, 0, t95 * t159 / 0.96e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = t7 * t162;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[1] = 0.0e0;

  t164 = params->lambda * t68 * t158;
  t167 = my_piecewise3(t52, 0, t144 * t164 / 0.96e2);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[2] = t7 * t167;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t170 = 0.1e1 / t25;
  t171 = t82 * t82;
  t174 = t78 * t7;
  t175 = 0.1e1 / t174;
  t176 = t17 * t175;
  t179 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t79 + 0.2e1 * t176);
  t183 = my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t170 * t171 + 0.5e1 / 0.3e1 * t26 * t179);
  t184 = t183 * t30;
  t188 = t85 * t90;
  t190 = t6 * t188 * t47;
  t192 = t6 * t86;
  t196 = 0.1e1 / t29 / t7;
  t197 = t28 * t196;
  t200 = t6 * t197 * t47 / 0.30e2;
  t201 = t6 * t91;
  t202 = t201 * t101;
  t204 = t33 * t33;
  t206 = 0.1e1 / t35 / t204;
  t209 = t32 * t206 * t38 * t43;
  t213 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t184 * t47 + t190 / 0.5e1 - t192 * t101 / 0.18e2 - t200 - t202 / 0.27e2 + 0.11e2 / 0.108e3 * t95 * t209);
  t214 = 0.1e1 / t58;
  t215 = t108 * t108;
  t218 = t53 * t175;
  t221 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t79 + 0.2e1 * t218);
  t225 = my_piecewise3(t57, 0, 0.10e2 / 0.9e1 * t214 * t215 + 0.5e1 / 0.3e1 * t59 * t221);
  t226 = t225 * t30;
  t230 = t111 * t90;
  t232 = t6 * t230 * t73;
  t234 = t61 * t196;
  t237 = t6 * t234 * t73 / 0.30e2;
  t239 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t226 * t73 + t232 / 0.5e1 - t237);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t105 + 0.2e1 * t121 + t7 * (t213 + t239);

  t242 = t170 * t125;
  t246 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t176);
  t250 = my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t242 * t82 + 0.5e1 / 0.3e1 * t26 * t246);
  t251 = t250 * t30;
  t255 = t128 * t90;
  t257 = t6 * t255 * t47;
  t259 = t6 * t129;
  t265 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t251 * t47 + t257 / 0.10e2 - t259 * t101 / 0.36e2 + t190 / 0.10e2 - t200 - t202 / 0.54e2);
  t266 = t214 * t136;
  t270 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t218);
  t274 = my_piecewise3(t57, 0, 0.10e2 / 0.9e1 * t266 * t108 + 0.5e1 / 0.3e1 * t59 * t270);
  t275 = t274 * t30;
  t279 = t139 * t90;
  t281 = t6 * t279 * t73;
  t284 = t6 * t112;
  t287 = t6 * t116;
  t288 = t287 * t150;
  t291 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t275 * t73 + t281 / 0.10e2 + t232 / 0.10e2 - t237 - t284 * t150 / 0.36e2 - t288 / 0.54e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[1] = t105 + t121 + t134 + t154 + t7 * (t265 + t291);

  t296 = t125 * t125;
  t301 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t79 + 0.2e1 * t176);
  t305 = my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t170 * t296 + 0.5e1 / 0.3e1 * t26 * t301);
  t306 = t305 * t30;
  t312 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t306 * t47 + t257 / 0.5e1 - t200);
  t313 = t136 * t136;
  t318 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t79 + 0.2e1 * t218);
  t322 = my_piecewise3(t57, 0, 0.10e2 / 0.9e1 * t214 * t313 + 0.5e1 / 0.3e1 * t59 * t318);
  t323 = t322 * t30;
  t328 = t6 * t140;
  t332 = t64 * t64;
  t334 = 0.1e1 / t66 / t332;
  t337 = t63 * t334 * t38 * t43;
  t341 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t323 * t73 + t281 / 0.5e1 - t328 * t150 / 0.18e2 - t237 - t288 / 0.27e2 + 0.11e2 / 0.108e3 * t144 * t337);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[2] = 0.2e1 * t134 + 0.2e1 * t154 + t7 * (t312 + t341);

  t347 = t201 * t159 / 0.144e3;
  t349 = params->lambda * t98 * t158;
  t353 = my_piecewise3(t1, 0, t192 * t159 / 0.96e2 + t347 - t95 * t349 / 0.36e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = t7 * t353 + t162;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[1] = 0.0e0;

  t358 = t287 * t164 / 0.144e3;
  t360 = my_piecewise3(t52, 0, t284 * t164 / 0.96e2 + t358);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[2] = t7 * t360 + t167;

  t365 = my_piecewise3(t1, 0, t259 * t159 / 0.96e2 + t347);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[3] = t7 * t365 + t162;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[4] = 0.0e0;

  t370 = params->lambda * t147 * t158;
  t374 = my_piecewise3(t52, 0, t328 * t164 / 0.96e2 + t358 - t144 * t370 / 0.36e2);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[5] = t7 * t374 + t167;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[5] = 0.0e0;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t379 = 0.1e1 / t25 / t20;
  t380 = t171 * t82;
  t383 = t170 * t82;
  t386 = t78 * t78;
  t387 = 0.1e1 / t386;
  t388 = t17 * t387;
  t391 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t175 - 0.6e1 * t388);
  t395 = my_piecewise3(t21, 0, -0.10e2 / 0.27e2 * t379 * t380 + 0.10e2 / 0.3e1 * t383 * t179 + 0.5e1 / 0.3e1 * t26 * t391);
  t396 = t395 * t30;
  t400 = t183 * t90;
  t402 = t6 * t400 * t47;
  t404 = t6 * t184;
  t407 = t85 * t196;
  t409 = t6 * t407 * t47;
  t411 = t6 * t188;
  t412 = t411 * t101;
  t417 = 0.1e1 / t29 / t78;
  t418 = t28 * t417;
  t421 = 0.2e1 / 0.45e2 * t6 * t418 * t47;
  t422 = t6 * t197;
  t423 = t422 * t101;
  t425 = t201 * t209;
  t429 = 0.1e1 / t35 / t204 / rho[0];
  t432 = t32 * t429 * t38 * t43;
  t436 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t396 * t47 + 0.3e1 / 0.10e2 * t402 - t404 * t101 / 0.12e2 - t409 / 0.10e2 - t412 / 0.9e1 + 0.11e2 / 0.36e2 * t192 * t209 + t421 + t423 / 0.54e2 + 0.11e2 / 0.54e2 * t425 - 0.77e2 / 0.162e3 * t95 * t432);
  t438 = 0.1e1 / t58 / t56;
  t439 = t215 * t108;
  t442 = t214 * t108;
  t445 = t53 * t387;
  t448 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t175 - 0.6e1 * t445);
  t452 = my_piecewise3(t57, 0, -0.10e2 / 0.27e2 * t438 * t439 + 0.10e2 / 0.3e1 * t442 * t221 + 0.5e1 / 0.3e1 * t59 * t448);
  t453 = t452 * t30;
  t457 = t225 * t90;
  t459 = t6 * t457 * t73;
  t461 = t111 * t196;
  t463 = t6 * t461 * t73;
  t465 = t61 * t417;
  t468 = 0.2e1 / 0.45e2 * t6 * t465 * t73;
  t470 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t453 * t73 + 0.3e1 / 0.10e2 * t459 - t463 / 0.10e2 + t468);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.3e1 * t213 + 0.3e1 * t239 + t7 * (t436 + t470);

  t473 = 0.2e1 * t265;
  t474 = 0.2e1 * t291;
  t475 = t379 * t125;
  t478 = t170 * t246;
  t483 = 0.2e1 * t175;
  t484 = 0.6e1 * t388;
  t486 = my_piecewise5(t11, 0, t15, 0, t483 - t484);
  t490 = my_piecewise3(t21, 0, -0.10e2 / 0.27e2 * t475 * t171 + 0.20e2 / 0.9e1 * t478 * t82 + 0.10e2 / 0.9e1 * t242 * t179 + 0.5e1 / 0.3e1 * t26 * t486);
  t491 = t490 * t30;
  t495 = t250 * t90;
  t498 = t6 * t495 * t47 / 0.5e1;
  t499 = t6 * t251;
  t502 = t128 * t196;
  t504 = t6 * t502 * t47;
  t506 = t6 * t255;
  t508 = t506 * t101 / 0.27e2;
  t516 = 0.3e1 / 0.20e2 * t6 * t491 * t47 + t498 - t499 * t101 / 0.18e2 - t504 / 0.30e2 - t508 + 0.11e2 / 0.108e3 * t259 * t209 + t402 / 0.10e2 - t409 / 0.15e2 - t412 / 0.27e2 + t421 + t423 / 0.81e2 + 0.11e2 / 0.162e3 * t425;
  t517 = my_piecewise3(t1, 0, t516);
  t518 = t438 * t136;
  t521 = t214 * t270;
  t526 = 0.6e1 * t445;
  t528 = my_piecewise5(t15, 0, t11, 0, -t483 - t526);
  t532 = my_piecewise3(t57, 0, -0.10e2 / 0.27e2 * t518 * t215 + 0.20e2 / 0.9e1 * t521 * t108 + 0.10e2 / 0.9e1 * t266 * t221 + 0.5e1 / 0.3e1 * t59 * t528);
  t533 = t532 * t30;
  t537 = t274 * t90;
  t540 = t6 * t537 * t73 / 0.5e1;
  t541 = t139 * t196;
  t543 = t6 * t541 * t73;
  t547 = t6 * t226;
  t550 = t6 * t230;
  t552 = t550 * t150 / 0.27e2;
  t553 = t6 * t234;
  t554 = t553 * t150;
  t557 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t533 * t73 + t540 - t543 / 0.30e2 + t459 / 0.10e2 - t463 / 0.15e2 + t468 - t547 * t150 / 0.36e2 - t552 + t554 / 0.162e3);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[1] = t213 + t239 + t473 + t474 + t7 * (t517 + t557);

  t560 = t379 * t296;
  t565 = t170 * t301;
  t569 = my_piecewise5(t11, 0, t15, 0, -t483 - t484);
  t573 = my_piecewise3(t21, 0, -0.10e2 / 0.27e2 * t560 * t82 + 0.20e2 / 0.9e1 * t242 * t246 + 0.10e2 / 0.9e1 * t565 * t82 + 0.5e1 / 0.3e1 * t26 * t569);
  t574 = t573 * t30;
  t578 = t305 * t90;
  t580 = t6 * t578 * t47;
  t582 = t6 * t306;
  t589 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t574 * t47 + t580 / 0.10e2 - t582 * t101 / 0.36e2 + t498 - t504 / 0.15e2 - t508 - t409 / 0.30e2 + t421 + t423 / 0.162e3);
  t590 = t438 * t313;
  t595 = t214 * t318;
  t599 = my_piecewise5(t15, 0, t11, 0, t483 - t526);
  t603 = my_piecewise3(t57, 0, -0.10e2 / 0.27e2 * t590 * t108 + 0.20e2 / 0.9e1 * t266 * t270 + 0.10e2 / 0.9e1 * t595 * t108 + 0.5e1 / 0.3e1 * t59 * t599);
  t604 = t603 * t30;
  t608 = t322 * t90;
  t610 = t6 * t608 * t73;
  t613 = t6 * t275;
  t616 = t6 * t279;
  t617 = t616 * t150;
  t623 = t287 * t337;
  t625 = 0.3e1 / 0.20e2 * t6 * t604 * t73 + t610 / 0.10e2 + t540 - t543 / 0.15e2 - t613 * t150 / 0.18e2 - t617 / 0.27e2 - t463 / 0.30e2 + t468 - t552 + t554 / 0.81e2 + 0.11e2 / 0.108e3 * t284 * t337 + 0.11e2 / 0.162e3 * t623;
  t626 = my_piecewise3(t52, 0, t625);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[2] = t473 + t474 + t312 + t341 + t7 * (t589 + t626);

  t631 = t296 * t125;
  t638 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t175 - 0.6e1 * t388);
  t642 = my_piecewise3(t21, 0, -0.10e2 / 0.27e2 * t379 * t631 + 0.10e2 / 0.3e1 * t242 * t301 + 0.5e1 / 0.3e1 * t26 * t638);
  t643 = t642 * t30;
  t650 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t643 * t47 + 0.3e1 / 0.10e2 * t580 - t504 / 0.10e2 + t421);
  t651 = t313 * t136;
  t658 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t175 - 0.6e1 * t445);
  t662 = my_piecewise3(t57, 0, -0.10e2 / 0.27e2 * t438 * t651 + 0.10e2 / 0.3e1 * t266 * t318 + 0.5e1 / 0.3e1 * t59 * t658);
  t663 = t662 * t30;
  t668 = t6 * t323;
  t679 = 0.1e1 / t66 / t332 / rho[1];
  t682 = t63 * t679 * t38 * t43;
  t686 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t663 * t73 + 0.3e1 / 0.10e2 * t610 - t668 * t150 / 0.12e2 - t543 / 0.10e2 - t617 / 0.9e1 + 0.11e2 / 0.36e2 * t328 * t337 + t468 + t554 / 0.54e2 + 0.11e2 / 0.54e2 * t623 - 0.77e2 / 0.162e3 * t144 * t682);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[3] = 0.3e1 * t312 + 0.3e1 * t341 + t7 * (t650 + t686);

  t692 = t411 * t159;
  t697 = t422 * t159 / 0.432e3;
  t698 = t201 * t349;
  t701 = params->lambda * t206 * t158;
  t705 = my_piecewise3(t1, 0, t404 * t159 / 0.96e2 + t692 / 0.72e2 - t192 * t349 / 0.18e2 - t697 - t698 / 0.27e2 + 0.11e2 / 0.108e3 * t95 * t701);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = t7 * t705 + 0.2e1 * t353;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[1] = 0.0e0;

  t710 = t550 * t164;
  t713 = t553 * t164 / 0.432e3;
  t715 = my_piecewise3(t52, 0, t547 * t164 / 0.96e2 + t710 / 0.72e2 - t713);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[2] = t7 * t715 + 0.2e1 * t360;

  t719 = t506 * t159;
  t726 = my_piecewise3(t1, 0, t499 * t159 / 0.96e2 + t719 / 0.144e3 - t259 * t349 / 0.36e2 + t692 / 0.144e3 - t697 - t698 / 0.54e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[3] = t7 * t726 + t353 + t365;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[4] = 0.0e0;

  t730 = t616 * t164;
  t735 = t287 * t370;
  t738 = my_piecewise3(t52, 0, t613 * t164 / 0.96e2 + t730 / 0.144e3 + t710 / 0.144e3 - t713 - t284 * t370 / 0.36e2 - t735 / 0.54e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[5] = t7 * t738 + t360 + t374;

  t745 = my_piecewise3(t1, 0, t582 * t159 / 0.96e2 + t719 / 0.72e2 - t697);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[6] = t7 * t745 + 0.2e1 * t365;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[7] = 0.0e0;

  t755 = params->lambda * t334 * t158;
  t759 = my_piecewise3(t52, 0, t668 * t164 / 0.96e2 + t730 / 0.72e2 - t328 * t370 / 0.18e2 - t713 - t735 / 0.27e2 + 0.11e2 / 0.108e3 * t144 * t755);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[8] = t7 * t759 + 0.2e1 * t374;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[9] = 0.0e0;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t765 = t6 * t395 * t90 * t47;
  t769 = t6 * t183 * t196 * t47;
  t773 = t6 * t85 * t417 * t47;
  t776 = 0.1e1 / t29 / t174;
  t780 = 0.14e2 / 0.135e3 * t6 * t28 * t776 * t47;
  t781 = t20 * t20;
  t783 = 0.1e1 / t25 / t781;
  t784 = t171 * t171;
  t790 = t179 * t179;
  t796 = 0.1e1 / t386 / t7;
  t797 = t17 * t796;
  t800 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t387 + 0.24e2 * t797);
  t804 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t783 * t784 - 0.20e2 / 0.9e1 * t379 * t171 * t179 + 0.10e2 / 0.3e1 * t170 * t790 + 0.40e2 / 0.9e1 * t383 * t391 + 0.5e1 / 0.3e1 * t26 * t800);
  t811 = t422 * t209;
  t813 = t201 * t432;
  t825 = t411 * t209;
  t827 = t6 * t396;
  t830 = t6 * t400;
  t831 = t830 * t101;
  t833 = t6 * t407;
  t834 = t833 * t101;
  t836 = t6 * t418;
  t837 = t836 * t101;
  t839 = 0.2e1 / 0.5e1 * t765 - t769 / 0.5e1 + 0.8e1 / 0.45e2 * t773 - t780 + 0.3e1 / 0.20e2 * t6 * t804 * t30 * t47 - 0.154e3 / 0.81e2 * t192 * t432 - 0.11e2 / 0.81e2 * t811 - 0.308e3 / 0.243e3 * t813 + 0.1309e4 / 0.486e3 * t95 * t32 / t35 / t204 / t33 * t38 * t43 + 0.11e2 / 0.18e2 * t404 * t209 + 0.22e2 / 0.27e2 * t825 - t827 * t101 / 0.9e1 - 0.2e1 / 0.9e1 * t831 + 0.2e1 / 0.27e2 * t834 - 0.8e1 / 0.243e3 * t837;
  t840 = my_piecewise3(t1, 0, t839);
  t841 = t56 * t56;
  t843 = 0.1e1 / t58 / t841;
  t844 = t215 * t215;
  t850 = t221 * t221;
  t855 = t53 * t796;
  t858 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t387 + 0.24e2 * t855);
  t862 = my_piecewise3(t57, 0, 0.40e2 / 0.81e2 * t843 * t844 - 0.20e2 / 0.9e1 * t438 * t215 * t221 + 0.10e2 / 0.3e1 * t214 * t850 + 0.40e2 / 0.9e1 * t442 * t448 + 0.5e1 / 0.3e1 * t59 * t858);
  t869 = t6 * t452 * t90 * t73;
  t873 = t6 * t225 * t196 * t73;
  t877 = t6 * t111 * t417 * t73;
  t882 = 0.14e2 / 0.135e3 * t6 * t61 * t776 * t73;
  t884 = my_piecewise3(t52, 0, 0.3e1 / 0.20e2 * t6 * t862 * t30 * t73 + 0.2e1 / 0.5e1 * t869 - t873 / 0.5e1 + 0.8e1 / 0.45e2 * t877 - t882);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.4e1 * t436 + 0.4e1 * t470 + t7 * (t840 + t884);

  t891 = t6 * t490 * t90 * t47;
  t895 = t6 * t250 * t196 * t47;
  t896 = t895 / 0.10e2;
  t899 = t6 * t128 * t417 * t47;
  t920 = 0.12e2 * t387;
  t921 = 0.24e2 * t797;
  t923 = my_piecewise5(t11, 0, t15, 0, -t920 + t921);
  t927 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t783 * t125 * t380 - 0.10e2 / 0.9e1 * t379 * t246 * t171 - 0.10e2 / 0.9e1 * t475 * t82 * t179 + 0.10e2 / 0.3e1 * t170 * t486 * t82 + 0.10e2 / 0.3e1 * t478 * t179 + 0.10e2 / 0.9e1 * t242 * t391 + 0.5e1 / 0.3e1 * t26 * t923);
  t934 = t506 * t209;
  t944 = t6 * t491;
  t947 = t6 * t495;
  t948 = t947 * t101;
  t950 = t6 * t502;
  t951 = t950 * t101;
  t952 = t951 / 0.54e2;
  t953 = 0.3e1 / 0.10e2 * t891 - t896 + 0.2e1 / 0.45e2 * t899 + t765 / 0.10e2 - t769 / 0.10e2 + 0.2e1 / 0.15e2 * t773 - t780 + 0.3e1 / 0.20e2 * t6 * t927 * t30 * t47 + 0.11e2 / 0.36e2 * t499 * t209 + 0.11e2 / 0.54e2 * t934 - 0.77e2 / 0.162e3 * t259 * t432 - 0.11e2 / 0.162e3 * t811 - 0.77e2 / 0.243e3 * t813 + 0.11e2 / 0.54e2 * t825 - t831 / 0.18e2 + t834 / 0.27e2 - 0.2e1 / 0.81e2 * t837 - t944 * t101 / 0.12e2 - t948 / 0.9e1 + t952;
  t954 = my_piecewise3(t1, 0, t953);
  t971 = 0.24e2 * t855;
  t973 = my_piecewise5(t15, 0, t11, 0, t920 + t971);
  t977 = my_piecewise3(t57, 0, 0.40e2 / 0.81e2 * t843 * t136 * t439 - 0.10e2 / 0.9e1 * t438 * t270 * t215 - 0.10e2 / 0.9e1 * t518 * t108 * t221 + 0.10e2 / 0.3e1 * t214 * t528 * t108 + 0.10e2 / 0.3e1 * t521 * t221 + 0.10e2 / 0.9e1 * t266 * t448 + 0.5e1 / 0.3e1 * t59 * t973);
  t984 = t6 * t532 * t90 * t73;
  t988 = t6 * t274 * t196 * t73;
  t989 = t988 / 0.10e2;
  t992 = t6 * t139 * t417 * t73;
  t997 = t6 * t453;
  t1000 = t6 * t457;
  t1001 = t1000 * t150;
  t1003 = t6 * t461;
  t1004 = t1003 * t150;
  t1005 = t1004 / 0.54e2;
  t1006 = t6 * t465;
  t1007 = t1006 * t150;
  t1009 = 0.3e1 / 0.20e2 * t6 * t977 * t30 * t73 + 0.3e1 / 0.10e2 * t984 - t989 + 0.2e1 / 0.45e2 * t992 + t869 / 0.10e2 - t873 / 0.10e2 + 0.2e1 / 0.15e2 * t877 - t882 - t997 * t150 / 0.36e2 - t1001 / 0.18e2 + t1005 - 0.2e1 / 0.243e3 * t1007;
  t1010 = my_piecewise3(t52, 0, t1009);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[1] = t436 + t470 + 0.3e1 * t517 + 0.3e1 * t557 + t7 * (t954 + t1010);

  t1019 = t6 * t305 * t196 * t47;
  t1026 = t6 * t573 * t90 * t47;
  t1038 = t246 * t246;
  t1051 = my_piecewise5(t11, 0, t15, 0, t921);
  t1055 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t783 * t296 * t171 - 0.40e2 / 0.27e2 * t475 * t82 * t246 - 0.10e2 / 0.27e2 * t560 * t179 + 0.20e2 / 0.9e1 * t170 * t1038 + 0.20e2 / 0.9e1 * t242 * t486 - 0.10e2 / 0.27e2 * t379 * t301 * t171 + 0.20e2 / 0.9e1 * t170 * t569 * t82 + 0.10e2 / 0.9e1 * t565 * t179 + 0.5e1 / 0.3e1 * t26 * t1051);
  t1068 = t6 * t574;
  t1071 = t6 * t578;
  t1072 = t1071 * t101;
  t1074 = -t1019 / 0.30e2 + t891 / 0.5e1 - 0.2e1 / 0.15e2 * t895 + 0.4e1 / 0.45e2 * t899 + t1026 / 0.5e1 - t769 / 0.30e2 + 0.4e1 / 0.45e2 * t773 - t780 + 0.3e1 / 0.20e2 * t6 * t1055 * t30 * t47 + 0.11e2 / 0.108e3 * t582 * t209 + 0.11e2 / 0.81e2 * t934 - 0.11e2 / 0.486e3 * t811 + t834 / 0.81e2 - 0.4e1 / 0.243e3 * t837 - 0.2e1 / 0.27e2 * t948 + 0.2e1 / 0.81e2 * t951 - t1068 * t101 / 0.18e2 - t1072 / 0.27e2;
  t1075 = my_piecewise3(t1, 0, t1074);
  t1084 = t270 * t270;
  t1097 = my_piecewise5(t15, 0, t11, 0, t971);
  t1101 = my_piecewise3(t57, 0, 0.40e2 / 0.81e2 * t843 * t313 * t215 - 0.40e2 / 0.27e2 * t518 * t108 * t270 - 0.10e2 / 0.27e2 * t590 * t221 + 0.20e2 / 0.9e1 * t214 * t1084 + 0.20e2 / 0.9e1 * t266 * t528 - 0.10e2 / 0.27e2 * t438 * t318 * t215 + 0.20e2 / 0.9e1 * t214 * t599 * t108 + 0.10e2 / 0.9e1 * t595 * t221 + 0.5e1 / 0.3e1 * t59 * t1097);
  t1108 = t6 * t603 * t90 * t73;
  t1112 = t6 * t322 * t196 * t73;
  t1117 = t6 * t533;
  t1120 = t6 * t537;
  t1121 = t1120 * t150;
  t1123 = t6 * t541;
  t1124 = t1123 * t150;
  t1133 = t550 * t337;
  t1135 = t553 * t337;
  t1137 = 0.3e1 / 0.20e2 * t6 * t1101 * t30 * t73 + t1108 / 0.5e1 - t1112 / 0.30e2 + t984 / 0.5e1 - 0.2e1 / 0.15e2 * t988 + 0.4e1 / 0.45e2 * t992 - t1117 * t150 / 0.18e2 - 0.2e1 / 0.27e2 * t1121 + t1124 / 0.81e2 - t873 / 0.30e2 + 0.4e1 / 0.45e2 * t877 - t882 - t1001 / 0.27e2 + 0.2e1 / 0.81e2 * t1004 - 0.4e1 / 0.243e3 * t1007 + 0.11e2 / 0.108e3 * t547 * t337 + 0.11e2 / 0.81e2 * t1133 - 0.11e2 / 0.486e3 * t1135;
  t1138 = my_piecewise3(t52, 0, t1137);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[2] = 0.2e1 * t517 + 0.2e1 * t557 + 0.2e1 * t589 + 0.2e1 * t626 + t7 * (t1075 + t1138);

  t1159 = my_piecewise5(t11, 0, t15, 0, t920 + t921);
  t1163 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t783 * t631 * t82 - 0.10e2 / 0.9e1 * t560 * t246 - 0.10e2 / 0.9e1 * t475 * t301 * t82 + 0.10e2 / 0.3e1 * t478 * t301 + 0.10e2 / 0.3e1 * t242 * t569 + 0.10e2 / 0.9e1 * t170 * t638 * t82 + 0.5e1 / 0.3e1 * t26 * t1159);
  t1170 = t6 * t642 * t90 * t47;
  t1172 = t6 * t643;
  t1181 = 0.3e1 / 0.20e2 * t6 * t1163 * t30 * t47 + t1170 / 0.10e2 - t1172 * t101 / 0.36e2 + 0.3e1 / 0.10e2 * t1026 - t1019 / 0.10e2 - t1072 / 0.18e2 - t896 + 0.2e1 / 0.15e2 * t899 + t952 + 0.2e1 / 0.45e2 * t773 - t780 - 0.2e1 / 0.243e3 * t837;
  t1182 = my_piecewise3(t1, 0, t1181);
  t1199 = my_piecewise5(t15, 0, t11, 0, -t920 + t971);
  t1203 = my_piecewise3(t57, 0, 0.40e2 / 0.81e2 * t843 * t651 * t108 - 0.10e2 / 0.9e1 * t590 * t270 - 0.10e2 / 0.9e1 * t518 * t318 * t108 + 0.10e2 / 0.3e1 * t521 * t318 + 0.10e2 / 0.3e1 * t266 * t599 + 0.10e2 / 0.9e1 * t214 * t658 * t108 + 0.5e1 / 0.3e1 * t59 * t1199);
  t1210 = t6 * t662 * t90 * t73;
  t1214 = t6 * t604;
  t1217 = t6 * t608;
  t1218 = t1217 * t150;
  t1225 = t616 * t337;
  t1233 = t287 * t682;
  t1235 = 0.3e1 / 0.20e2 * t6 * t1203 * t30 * t73 + t1210 / 0.10e2 + 0.3e1 / 0.10e2 * t1108 - t1112 / 0.10e2 - t1214 * t150 / 0.12e2 - t1218 / 0.18e2 - t989 + 0.2e1 / 0.15e2 * t992 - t1121 / 0.9e1 + t1124 / 0.27e2 + 0.11e2 / 0.36e2 * t613 * t337 + 0.11e2 / 0.54e2 * t1225 + 0.2e1 / 0.45e2 * t877 - t882 + t1005 - 0.2e1 / 0.81e2 * t1007 + 0.11e2 / 0.54e2 * t1133 - 0.11e2 / 0.162e3 * t1135 - 0.77e2 / 0.162e3 * t284 * t682 - 0.77e2 / 0.243e3 * t1233;
  t1236 = my_piecewise3(t52, 0, t1235);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[3] = 0.3e1 * t589 + 0.3e1 * t626 + t650 + t686 + t7 * (t1182 + t1236);

  t1241 = t296 * t296;
  t1246 = t301 * t301;
  t1253 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t387 + 0.24e2 * t797);
  t1257 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t783 * t1241 - 0.20e2 / 0.9e1 * t560 * t301 + 0.10e2 / 0.3e1 * t170 * t1246 + 0.40e2 / 0.9e1 * t242 * t638 + 0.5e1 / 0.3e1 * t26 * t1253);
  t1266 = my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t1257 * t30 * t47 + 0.2e1 / 0.5e1 * t1170 - t1019 / 0.5e1 + 0.8e1 / 0.45e2 * t899 - t780);
  t1267 = t313 * t313;
  t1272 = t318 * t318;
  t1279 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t387 + 0.24e2 * t855);
  t1283 = my_piecewise3(t57, 0, 0.40e2 / 0.81e2 * t843 * t1267 - 0.20e2 / 0.9e1 * t590 * t318 + 0.10e2 / 0.3e1 * t214 * t1272 + 0.40e2 / 0.9e1 * t266 * t658 + 0.5e1 / 0.3e1 * t59 * t1279);
  t1309 = t6 * t663;
  t1312 = 0.3e1 / 0.20e2 * t6 * t1283 * t30 * t73 - t1112 / 0.5e1 + 0.2e1 / 0.5e1 * t1210 + 0.8e1 / 0.45e2 * t992 - t882 - 0.154e3 / 0.81e2 * t328 * t682 + 0.1309e4 / 0.486e3 * t144 * t63 / t66 / t332 / t64 * t38 * t43 + 0.11e2 / 0.18e2 * t668 * t337 - 0.11e2 / 0.81e2 * t1135 - 0.2e1 / 0.9e1 * t1218 + 0.22e2 / 0.27e2 * t1225 - 0.308e3 / 0.243e3 * t1233 + 0.2e1 / 0.27e2 * t1124 - 0.8e1 / 0.243e3 * t1007 - t1309 * t150 / 0.9e1;
  t1313 = my_piecewise3(t52, 0, t1312);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[4] = 0.4e1 * t650 + 0.4e1 * t686 + t7 * (t1266 + t1313);

  t1319 = t830 * t159;
  t1323 = t833 * t159;
  t1325 = t411 * t349;
  t1330 = t836 * t159 / 0.324e3;
  t1331 = t422 * t349;
  t1333 = t201 * t701;
  t1340 = my_piecewise3(t1, 0, t827 * t159 / 0.96e2 + t1319 / 0.48e2 - t404 * t349 / 0.12e2 - t1323 / 0.144e3 - t1325 / 0.9e1 + 0.11e2 / 0.36e2 * t192 * t701 + t1330 + t1331 / 0.54e2 + 0.11e2 / 0.54e2 * t1333 - 0.77e2 / 0.162e3 * t95 * params->lambda * t429 * t158);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = t7 * t1340 + 0.3e1 * t705;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[1] = 0.0e0;

  t1345 = t1000 * t164;
  t1347 = t1003 * t164;
  t1350 = t1006 * t164 / 0.324e3;
  t1352 = my_piecewise3(t52, 0, t997 * t164 / 0.96e2 + t1345 / 0.48e2 - t1347 / 0.144e3 + t1350);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[2] = t7 * t1352 + 0.3e1 * t715;

  t1354 = 0.2e1 * t726;
  t1358 = t947 * t159 / 0.72e2;
  t1361 = t950 * t159;
  t1364 = t506 * t349 / 0.27e2;
  t1372 = t944 * t159 / 0.96e2 + t1358 - t499 * t349 / 0.18e2 - t1361 / 0.432e3 - t1364 + 0.11e2 / 0.108e3 * t259 * t701 + t1319 / 0.144e3 - t1323 / 0.216e3 - t1325 / 0.27e2 + t1330 + t1331 / 0.81e2 + 0.11e2 / 0.162e3 * t1333;
  t1373 = my_piecewise3(t1, 0, t1372);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[3] = t7 * t1373 + t1354 + t705;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[4] = 0.0e0;

  t1375 = 0.2e1 * t738;
  t1379 = t1120 * t164 / 0.72e2;
  t1380 = t1123 * t164;
  t1387 = t550 * t370 / 0.27e2;
  t1388 = t553 * t370;
  t1391 = my_piecewise3(t52, 0, t1117 * t164 / 0.96e2 + t1379 - t1380 / 0.432e3 + t1345 / 0.144e3 - t1347 / 0.216e3 + t1350 - t547 * t370 / 0.36e2 - t1387 + t1388 / 0.162e3);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[5] = t7 * t1391 + t1375 + t715;

  t1395 = t1071 * t159;
  t1403 = my_piecewise3(t1, 0, t1068 * t159 / 0.96e2 + t1395 / 0.144e3 - t582 * t349 / 0.36e2 + t1358 - t1361 / 0.216e3 - t1364 - t1323 / 0.432e3 + t1330 + t1331 / 0.162e3);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[6] = t7 * t1403 + t1354 + t745;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[7] = 0.0e0;

  t1407 = t1217 * t164;
  t1412 = t616 * t370;
  t1418 = t287 * t755;
  t1420 = t1214 * t164 / 0.96e2 + t1407 / 0.144e3 + t1379 - t1380 / 0.216e3 - t613 * t370 / 0.18e2 - t1412 / 0.27e2 - t1347 / 0.432e3 + t1350 - t1387 + t1388 / 0.81e2 + 0.11e2 / 0.108e3 * t284 * t755 + 0.11e2 / 0.162e3 * t1418;
  t1421 = my_piecewise3(t52, 0, t1420);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[8] = t7 * t1421 + t1375 + t759;

  t1429 = my_piecewise3(t1, 0, t1172 * t159 / 0.96e2 + t1395 / 0.48e2 - t1361 / 0.144e3 + t1330);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[9] = t7 * t1429 + 0.3e1 * t745;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[10] = 0.0e0;

  t1448 = my_piecewise3(t52, 0, t1309 * t164 / 0.96e2 + t1407 / 0.48e2 - t668 * t370 / 0.12e2 - t1380 / 0.144e3 - t1412 / 0.9e1 + 0.11e2 / 0.36e2 * t328 * t755 + t1350 + t1388 / 0.54e2 + 0.11e2 / 0.54e2 * t1418 - 0.77e2 / 0.162e3 * t144 * params->lambda * t679 * t158);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[11] = t7 * t1448 + 0.3e1 * t759;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[14] = 0.0e0;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}

