package org.jboss.cache.commands.read;

import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.DataCommand;

/**
 * An abstract class providing basic functionality of all {@link DataCommand}s.
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
public abstract class AbstractDataCommand implements DataCommand
{
   protected Fqn fqn;
   protected DataContainer dataContainer;

   public void initialize(DataContainer dataContainer)
   {
      this.dataContainer = dataContainer;
   }

   public Fqn getFqn()
   {
      return fqn;
   }

   void setFqn(Fqn fqn)
   {
      this.fqn = fqn;
   }

   /**
    * Basic versions of these methods
    */
   public Object[] getParameters()
   {
      return new Object[]{fqn};
   }

   /**
    * Basic versions of these methods
    */
   public void setParameters(int commandId, Object[] args)
   {
      fqn = (Fqn) args[0];
   }

   @Override
   public boolean equals(Object o)
   {
      if (this == o) return true;
      if (o == null || getClass() != o.getClass()) return false;

      AbstractDataCommand that = (AbstractDataCommand) o;

      return !(fqn != null ? !fqn.equals(that.fqn) : that.fqn != null);
   }

   @Override
   public int hashCode()
   {
      int result;
      result = (fqn != null ? fqn.hashCode() : 0);
      result = 31 * result + getClass().hashCode();
      return result;
   }

   @Override
   public String toString()
   {
      return getClass().getSimpleName() +
            "{" +
            "fqn=" + fqn +
            '}';
   }
}
