#include "mfhdf.h"

#define X_LENGTH 10
#define Y_LENGTH 10
#define NUM_DSETS 40

main( ) 
{
    int32 sd_id, sds_id, istat, sds_idx;
    int32 sds_list[NUM_DSETS];
    int32 dims[2], start[2], edges[2], rank, num_datasets=0, num_attrs=0;
    intn i, j, k, index;
    intn num_errs = 0;
    char file_attr[116] = "This file was generated by the program manySDSs.c in hdf4/mfhdf/dumper/testfiles to test the flag -k in hdp dumpsds";
    char names[NUM_DSETS][8] = {{"data1"},{"data2"},{"data3"},{"data4"},
	{"data5"},{"data6"},{"data7"},{"data8"},{"data9"},{"data10"},
	{"data11"},{"data12"},{"data13"},{"data14"},{"data15"},{"data16"},
	{"data17"},{"data18"},{"data19"},{"data20"},{"data21"},{"data22"},
	{"data23"},{"data24"},{"data25"},{"data26"},{"data27"},{"data28"},
	{"data29"},{"data30"},{"data31"},{"data32"},{"data33"},{"data34"},
	{"data35"},{"data36"},{"data37"},{"data38"},{"data39"},{"data40"}};

    /* Create and open the file and initiate the SD interface. */
    sd_id = SDstart("sds_empty_many.hdf", DFACC_CREATE);
    if (sd_id == FAIL)
    {
	fprintf(stderr, "manySDSs: SDstart returns sd_id: %d\n", sd_id);
	exit(-1);
    }

    /* Add file attribute to note about the file's history */
    istat = SDsetattr(sd_id, "file_contents", DFNT_CHAR8, 116, (VOIDP)file_attr);
    if (istat == FAIL)
    {
	fprintf(stderr, "manySDSs: SDsetattr returns status: %d\n", istat);
	exit(-1);
    }
 
    /* Define the rank and dimensions of the data set to be created. */
    rank = 2;
    dims[0] = SD_UNLIMITED;
    dims[1] = X_LENGTH;

    /* Define the location, pattern, and size of the data set */
    for (i = 0; i < rank; i++)  start[i] = 0;

    for (index = 0; index < NUM_DSETS; index++)
    {
	/* Create each data set. */
	sds_list[index] = SDcreate(sd_id, names[index], DFNT_INT16, rank, dims);
	if (sds_list[index] == FAIL)
	{
	    fprintf(stderr, "manySDSs: SDcreate returns sds_list[%d]: %d\n", index, sds_list[index]);
	    exit(-1);
	}
	/* Terminate access to each data set. */
	istat = SDendaccess(sds_list[index]);
	if (istat == FAIL)
	{
	    fprintf(stderr, "manySDSs: SDendaccess returns status: %d\n", istat);
	    exit(-1);
	}
    }

    /* Terminate access to the SD interface and close the file. */
    istat = SDend(sd_id);
    if (istat == FAIL)
    {
	fprintf(stderr, "manySDSs: SDend returns: %d\n", istat);
	exit(-1);
    }
}
