/*
 * @(#)HashtableInputStreamGenerator.java
 *
 * Copyright (C) 2001,2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.io.v1;

import java.io.InputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.io.ByteArrayInputStream;



/**
 * A type of class which can generate a new InputStream based on a entry
 * in a Hashtable.  It will create a StringBufferInputStream based on the
 * <tt>toString</tt> of the data.
 *
 * @author   Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since    0.9.1d (sometime in 2001)
 * @version  $Date: 2003/02/10 22:52:45 $
 */
public class HashtableInputStreamGenerator implements IInputStreamGenerator
{
    private Hashtable map;
    private String orig;
    
    /**
     * Accepts the name of the 1st file loaded.  All files generated from
     * this generator will be relative to its location.
     */
    public HashtableInputStreamGenerator( Hashtable map )
    {
        this.map = map;
    }
    
    
    public String getFullName( String relativeName )
    {
        return relativeName;
    }
    
    
    public InputStream createInputStream( String relativeName )
            throws IOException
    {
        if (relativeName == null)
        {
            throw new IOException("null name");
        }
        
        Object o = this.map.get( relativeName );
        if (o == null)
        {
            throw new IOException("resource '"+relativeName+"' does not exist");
        }
        
        return new ByteArrayInputStream( o.toString().getBytes() );
    }
}
