/*
 * @(#)IUrlClassLoader.java    1.0.0 11/17/2000 - 11:38:45
 *
 * Copyright (C) 2000,2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;



/**
 * An interface for loading a specific class from a given URL (which is
 * probably a Jar file).  Classes returned shouldn't be cached.
 *
 * @author  Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version $Date: 2003/02/10 22:52:36 $
 * @since   November 17, 2000 (GroboUtils Alpha 0.9.0)
 */
public interface IUrlClassLoader
{
    //----------------------------
    // Public data
    
    //----------------------------
    // Public abstract methods
    
    
    /**
     * Load the given class from the given URL.  If the URL is <tt>null</tt>,
     * then it is up to the classloader to figure out where to load it from.
     * This should, in general, load the class from the default class loader.
     *
     * @param className the exact class name to load.
     * @param url the URL from which the class is loaded.  If this is
     *    <tt>null</tt>, then the returned class is implementation specific.
     * @return the loaded Class instance, or <tt>null</tt> if the class could
     *    not be found.
     */
    public Class loadClass( String className, String url );
    
    
    /**
     * Call to flush any cache stored in the interface.  This allows for
     * a class loader to cache results, and free up memory when it is
     * not needed.
     */
    public void flush();
}

