.\" The first line of this file must contain the '"[e][r][t][v] line
.\" to tell man to run the appropriate filter "t" for table.
.\"
.\"	$Id$
.\"
.\"######################################################################
.\"#									#
.\"#			   Copyright (C)  2006				#
.\"#	     			Internet2				#
.\"#			   All Rights Reserved				#
.\"#									#
.\"######################################################################
.\"
.\"	File:		pfstore.man
.\"
.\"	Author:		Jeff Boote
.\"			Internet2
.\"
.\"	Date:		Sun Nov  5 15:00:39 MST 2006
.\"
.\"	Description:	
.\"
.TH pfstore 1 "$Date$"
.SH NAME
pfstore \- Used to create and manage a pass-phrase store.
.SH SYNOPSIS
.B pfstore 
[\fI-n\fR] [\fI-d\fR] \fI-f pfsfile identity
.SH OPTIONS
.TP
\fB\-n\fR
Create the file
.TP
\fB\-d\fR
Delete given identity from the store
.TP
\fB\-f pfsfile\fR
Specifies file that holds identity/pass-phrase pairs
.SH DESCRIPTION
.B pfstore
is used to create and manage files that hold identity/pass-phrase pairs. It is
primarily used to manage the \fIowampd.pfs\fR file for \fBowampd\fR.
.PP
If the \fI\-d\fR option is not specified, then \fBpfstore\fR prompts
the caller for a pass-phrase. The pass-phrase is hex-encoded and
saved in the \fIpfsfile\fR with the associated \fIidentity\fR.
If the given \fIidentity\fR
already exists in the \fIpfsfile\fR, the previous pass-phrase is overwritten
with the new one.
.PP
\fIpfsfiles\fR generated by \fBpfstore\fR are formatted for use with
\fBOWAMP\fR.
.SH PFSFILE FORMAT
\fBpfstore\fR generates lines of the format:
.LP
test	54b0c58c7ce9f2a8b551351102ee0938
.PP
An \fIidentity\fR, followed by whitespace, followed by a variable-length
hex-encoded pass-phrase.
.PP
No other text is allowed on these lines; however, comment lines may be
added. Comment lines are any line where the first non-white space character
is '\fB#\fR'.
.SH EXAMPLES
\fBpfstore \-f /usr/local/etc/owampd.pfs testuser\fP
.IP
Adds a pass-phrase for the identity \fItestuser\fR. The user is prompted for
a pass-phrase. If the file does not exist, an error message will
be printed and no action will be taken.
.LP
\fBpfstore \-f /usr/local/etc/owampd.pfs \-n testuser\fP
.IP
Creates the file before doing the same as above. If the file already
exists, an error message will be printed and no action will be taken.
.LP
\fBpfstore \-f /usr/local/etc/owampd.pfs \-d testuser\fP
.IP
Deletes the identity \fItestuser\fR from the pfsfile.
If the file does not exist, an error message will be printed and no action will be taken.
.LP
.SH SECURITY CONSIDERATIONS
The pass-phrases in the \fIpfsfile\fR are not encrypted in any way; they
are simply hex-encoded. The security
of these pass-phrases is completely dependent upon the security of the
filesystem and the discretion of the system administrator.
.SH RESTRICTIONS
\fIidentity\fR names are restricted to 80 characters.
.SH SEE ALSO
owping(1), owampd(1), owampd(1)
and the \%http://e2epi.internet2.edu/owamp web site.
.SH ACKNOWLEDGMENTS
This material is based, in part, on work supported by the National Science
Foundation (NSF) under Grant No. ANI-0314723. Any opinions, findings, and
conclusions or recommendations expressed in this material are those of
the author(s) and do not necessarily reflect the views of the NSF.
