/*!

\if MANPAGES
\page wlmscpfs DICOM Basic Worklist Management SCP (based on data files)
\else
\page wlmscpfs wlmscpfs: DICOM Basic Worklist Management SCP (based on data files)
\endif

\section wlmscpfs_synopsis SYNOPSIS

\verbatim
wlmscpfs [options] port
\endverbatim

\section wlmscpfs_description DESCRIPTION

The \b wlmscpfs application implements a Service Class Provider (SCP) for the
Basic Worklist Management Service.  The application will listen on a specified
TCP/IP port for incoming association requests from a Worklist Management SCU.
In case an association was acknowledged and a worklist query was received, the
\b wlmscpfs application will query particular files in a certain directory
(which can be specified through corresponding program options) on the file
system for corresponding worklist information, and it will send this
information back to the calling Worklist Management SCU.  Aside from dealing
with Worklist Management queries, the \b wlmscpfs application also supports
the Verification Service Class as an SCP.

\section wlmscpfs_parameters PARAMETERS

\verbatim
port  tcp/ip port number to listen on
\endverbatim

\section wlmscpfs_options OPTIONS

\subsection wlmscpfs_general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

        --arguments
          print expanded command line arguments

  -q    --quiet
          quiet mode, print no warnings and errors

  -v    --verbose
          verbose mode, print processing details

  -d    --debug
          debug mode, print debug information

  -ll   --log-level  [l]evel: string constant
          (fatal, error, warn, info, debug, trace)
          use level l for the logger

  -lc   --log-config  [f]ilename: string
          use config file f for the logger
\endverbatim

\subsection wlmscpfs_multiprocess_options multi-process options
\verbatim
  -s    --single-process
          single process mode

        --fork
          fork child process for each association (default)
\endverbatim

\subsection wlmscpfs_input_options input options
\verbatim
general:

  -dfp  --data-files-path  [p]ath: string (default: .)
          path to worklist data files

handling of worklist files:

  -efr  --enable-file-reject
          enable rejection of incomplete worklist files (default)

  -dfr  --disable-file-reject
          disable rejection of incomplete worklist files
\endverbatim

\subsection wlmscpfs_processing_options processing options
\verbatim
returned character set:

  -cs0  --return-no-char-set
          return no specific character set (default)

  -cs1  --return-iso-ir-100
          return specific character set ISO IR 100

  -csk  --keep-char-set
          return character set provided in file

other processing options:

  -nse  --no-sq-expansion
          disable expansion of empty sequences in C-FIND
          request messages
\endverbatim

\subsection wlmscpfs_network_options network options
\verbatim
preferred network transfer syntaxes:

  +x=   --prefer-uncompr
          prefer explicit VR local byte order (default)

  +xe   --prefer-little
          prefer explicit VR little endian TS

  +xb   --prefer-big
          prefer explicit VR big endian TS

  +xd   --prefer-deflated
          prefer deflated explicit VR little endian TS

  +xi   --implicit
          accept implicit VR little endian TS only

network host access control (tcp wrapper):

  -ac   --access-full
          accept connections from any host (default)

  +ac   --access-control
          enforce host access control rules

post-1993 value representations:

  +u    --enable-new-vr
          enable support for new VRs (UN/UT) (default)

  -u    --disable-new-vr
          disable support for new VRs, convert to OB

deflate compression level (only with --prefer-deflated):

  +cl   --compression-level  [l]evel: integer (default: 6)
          0=uncompressed, 1=fastest, 9=best compression

other network options:

  -ta   --acse-timeout  [s]econds: integer (default: 30)
          timeout for ACSE messages

  -td   --dimse-timeout  [s]econds: integer (default: unlimited)
          timeout for DIMSE messages

        --max-associations  [a]ssocs: integer (default: 50)
          limit maximum number of parallel associations

        --refuse
          refuse association

        --reject
          reject association if no implementation class UID

        --no-fail
          don't fail on an invalid query

        --sleep-after  [s]econds: integer
          sleep s seconds after find (default: 0)

        --sleep-during  [s]econds: integer
          sleep s seconds during find (default: 0)

  -pdu  --max-pdu  [n]umber of bytes: integer (4096..131072)
          set max receive pdu to n bytes (default: 16384)

  -dhl  --disable-host-lookup
          disable hostname lookup
\endverbatim

\section wlmscpfs_notes NOTES

The semantic impacts of the above mentioned options is clear for the majority
of options.  Some particular options, however, are so specific that they need
detailed descriptions which will be given in this passage.

The returned character set options are intended for situations in which the
\b wlmscpfs application will return attribute values which are not composed of
characters from the DICOM default character repertoire.  In such cases, for
example option \e --return-iso-ir-100 can be used to specify that a response
to a modality's worklist management C-FIND request shall contain DICOM's
Specific Character Set attribute (0008,0005) with a corresponding value,
indicating the character repertoire from which the characters of returned
attribute values were taken (in this example the repertoire ISO IR 100).
Please note that the \b wlmscpfs application will not make sure that all
returned values are actually made up of this character repertoire; the
application expects this to be the case.

In general, the Specific Character Set attribute (0008,0005) will only be
included in the C-FIND response if it contains any attributes that are affected
by the character set, i.e. for value representations PN, LO, LT, SH, ST and UT.

Please note that a C-FIND request which is handled by this application may
contain DICOM's Specific Character Set attribute (0008,0005), but this
application will never use this attribute's value for matching.  Besides, the
question if DICOM's Specific Character Set attribute (0008,0005) will be
contained in a C-FIND response which is returned by this application is always
determined by the returned character set option which was specified when this
application was started.

The options --enable-file-reject and --disable-file-reject can be used to
enable or disable a file rejection mechanism which makes sure only complete
worklist files will be used during the matching process.  A worklist file is
considered to be complete if it contains all necessary type 1 information
which the SCP might have to return to an SCU in a C-FIND response message.
Table K.6-1 in part 4 annex K of the DICOM standard lists all corresponding
type 1 attributes (see column "Return Key Type").

\subsection wlmscpfs_dicom_conformance DICOM Conformance

The \b wlmscpfs application supports the following SOP Classes as an SCP:

\verbatim
VerificationSOPClass                  1.2.840.10008.1.1
FINDModalityWorklistInformationModel  1.2.840.10008.5.1.4.31
\endverbatim

The \b wlmscpfs application will accept presentation contexts for all of the
abovementioned supported SOP Classes using any of the transfer syntaxes:

\verbatim
LittleEndianImplicitTransferSyntax    1.2.840.10008.1.2
LittleEndianExplicitTransferSyntax    1.2.840.10008.1.2.1
BigEndianExplicitTransferSyntax       1.2.840.10008.1.2.2
\endverbatim

The default behavior of the \b wlmscpfs application is to prefer transfer
syntaxes having an explicit encoding over the default implicit transfer
syntax.  If \b wlmscpfs is running on big-endian hardware it will prefer
BigEndianExplicit to LittleEndianExplicit transfer syntax (and vice versa).
This behavior can be changed with the \e --prefer options (see above).

If compiled with zlib support enabled (see \e --version output) and if
option \e --prefer-deflated is used, also the following transfer syntax
is accepted.

\verbatim
DeflatedExplicitVRLittleEndianTransferSyntax  1.2.840.10008.1.2.1.99
\endverbatim

The \b wlmscpfs application does not support extended negotiation.

Currently, the \b wlmscpfs application supports the following attributes as
matching keys:

\verbatim
(0008,0020) StudyDate
(0008,0030) StudyTime
(0008,0050) AccessionNumber
(0008,0090) ReferringPhysicianName
(0010,0010) PatientName
(0010,0020) PatientID
(0010,0021) IssuerOfPatientID
(0010,0030) PatientBirthDate
(0010,0040) PatientSex
(0010,2297) Responsible Person
(0010,2298) Responsible Person Role
(0032,1032) RequestingPhysician
(0038,0010) AdmissionID
(0040,0100) ScheduledProcedureStepSequence
  (0008,0060) > Modality
  (0040,0001) > ScheduledStationAETitle
  (0040,0002) > ScheduledProcedureStepStartDate
  (0040,0003) > ScheduledProcedureStepStartTime
  (0040,0006) > ScheduledPerformingPhysicianName
(0040,1001) RequestedProcedureID
(0040,1003) RequestedProcedurePriority
\endverbatim

As return keys the following attributes are currently supported by \b wlmscpfs:

\verbatim
(0008,0020) StudyDate
(0008,0030) StudyTime
(0008,0050) AccessionNumber
(0008,0080) InstitutionName
(0008,0081) InstitutionAddress
(0008,0090) ReferringPhysicianName
(0008,1080) AdmittingDiagnosesDescription
(0008,1110) ReferencedStudySequence
  (0008,1150) > ReferencedSOPClassUID
  (0008,1155) > ReferencedSOPInstanceUID
(0008,1120) ReferencedPatientSequence
  (0008,1150) > ReferencedSOPClassUID
  (0008,1155) > ReferencedSOPInstanceUID
(0010,0010) PatientName
(0010,0020) PatientID
(0010,0021) IssuerOfPatientID
(0010,0030) PatientBirthDate
(0010,0040) PatientSex
(0010,1000) OtherPatientIDs (retired)
(0010,1001) OtherPatientNames
(0010,1020) PatientSize
(0010,1030) PatientWeight
(0010,1040) PatientAddress
(0010,1080) MilitaryRank
(0010,2000) MedicalAlerts
(0010,2110) ContrastAllergies
(0010,2160) EthnicGroup
(0010,21a0) SmokingStatus
(0010,21b0) AdditionalPatientHistory
(0010,21c0) PregnancyStatus
(0010,21d0) LastMenstrualDate
(0010,2297) ResponsiblePerson
(0010,2298) ResponsiblePersonRole
(0010,4000) PatientComments
(0020,000d) StudyInstanceUID
(0032,1032) RequestingPhysician
(0032,1033) RequestingService
(0032,1060) RequestedProcedureDescription
(0032,1064) RequestedProcedureCodeSequence
  (0008,0100) > CodeValue
  (0008,0102) > CodingSchemeDesignator
  (0008,0103) > CodingSchemeVersion
  (0008,0104) > CodeMeaning
(0038,0010) AdmissionID
(0038,0011) IssuerOfAdmissionID
(0038,0050) SpecialNeeds
(0038,0300) CurrentPatientLocation
(0038,0500) PatientState
(0040,0100) ScheduledProcedureStepSequence
  (0008,0060) > Modality
  (0032,1070) > RequestedContrastAgent
  (0040,0001) > ScheduledStationAETitle
  (0040,0002) > ScheduledProcedureStepStartDate
  (0040,0003) > ScheduledProcedureStepStartTime
  (0040,0004) > ScheduledProcedureStepEndDate
  (0040,0005) > ScheduledProcedureStepEndTime
  (0040,0006) > ScheduledPerformingPhysicianName
  (0040,0007) > ScheduledProcedureStepDescription
  (0040,0008) > ScheduledProtocolCodeSequence
    (0008,0100) > > CodeValue
    (0008,0102) > > CodingSchemeDesignator
    (0008,0103) > > CodingSchemeVersion
    (0008,0104) > > CodeMeaning
  (0040,0009) > ScheduledProcedureStepID
  (0040,0010) > ScheduledStationName
  (0040,0011) > ScheduledProcedureStepLocation
  (0040,0012) > PreMedication
  (0040,0020) > ScheduledProcedureStepStatus
  (0040,0400) > CommentsOnTheScheduledProcedureStep
(0040,1001) RequestedProcedureID
(0040,1002) ReasonForTheRequestedProcedure
(0040,1003) RequestedProcedurePriority
(0040,1004) PatientTransportArrangements
(0040,1005) RequestedProcedureLocation
(0040,1008) ConfidentialityCode
(0040,1009) ReportingPriority
(0040,1010) NamesOfIntendedRecipientsOfResults
(0040,1400) RequestedProcedureComments
(0040,2001) ReasonForTheImagingServiceRequest
(0040,2004) IssueDateOfImagingServiceRequest
(0040,2005) IssueTimeOfImagingServiceRequest
(0040,2008) OrderEnteredBy
(0040,2009) OrderEnterersLocation
(0040,2010) OrderCallbackPhoneNumber
(0040,2016) PlacerOrderNumberImagingServiceRequest
(0040,2017) FillerOrderNumberImagingServiceRequest
(0040,2400) ImagingServiceRequestComments
(0040,3001) ConfidentialityConstraintOnPatientDataDescription
\endverbatim

The attribute (0008,0005) SpecificCharacterSet is a special case and its
support by \b wlmscpfs is discussed in the NOTES section above.

\subsection wlmscpfs_access_control Access Control

When compiled on Unix platforms with TCP wrapper support, host-based access
control can be enabled with the \e --access-control command line option.  In
this case the access control rules defined in the system's host access control
tables for \b wlmscpfs are enforced.  The default locations of the host access
control tables are <em>/etc/hosts.allow</em> and <em>/etc/hosts.deny</em>.
Further details are described in <b>hosts_access</b>(5).

\section wlmscpfs_logging LOGGING

The level of logging output of the various command line tools and underlying
libraries can be specified by the user.  By default, only errors and warnings
are written to the standard error stream.  Using option \e --verbose also
informational messages like processing details are reported.  Option
\e --debug can be used to get more details on the internal activity, e.g. for
debugging purposes.  Other logging levels can be selected using option
\e --log-level.  In \e --quiet mode only fatal errors are reported.  In such
very severe error events, the application will usually terminate.  For more
details on the different logging levels, see documentation of module "oflog".

In case the logging output should be written to file (optionally with logfile
rotation), to syslog (Unix) or the event log (Windows) option \e --log-config
can be used.  This configuration file also allows for directing only certain
messages to a particular output stream and for filtering certain messages
based on the module or application where they are generated.  An example
configuration file is provided in <em>\<etcdir\>/logger.cfg</em>.

\section wlmscpfs_command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behavior conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator unless they appear between two
quotation marks) prior to any further evaluation.  Please note that a command
file cannot contain another command file.  This simple but effective approach
allows one to summarize common combinations of options/parameters and avoids
longish and confusing command lines (an example is provided in file
<em>\<datadir\>/dumppat.txt</em>).

\section wlmscpfs_environment ENVIRONMENT

The \b wlmscpfs utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<datadir\>/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behavior should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  On Windows systems,
a semicolon (";") is used as a separator.  The data dictionary code will
attempt to load each file specified in the \e DCMDICTPATH environment variable.
It is an error if no data dictionary can be loaded.

\section wlmscpfs_copyright COPYRIGHT

Copyright (C) 1996-2017 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
