/** @file dgrep-clo.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef DGREP_CLO_H
#define DGREP_CLO_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "version.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "dgrep"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "dgrep"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION dateutils_version_string
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  const char *quiet_help; /**< @brief Suppress message about date/time and duration parser errors. help description.  */
  char ** input_format_arg;	/**< @brief Input format, can be used multiple times.
  Each date/time will be passed to the input format parsers in the order they are given, if a date/time can be read successfully with a given input format specifier string, that value will be used..  */
  char ** input_format_orig;	/**< @brief Input format, can be used multiple times.
  Each date/time will be passed to the input format parsers in the order they are given, if a date/time can be read successfully with a given input format specifier string, that value will be used. original value given at command line.  */
  unsigned int input_format_min; /**< @brief Input format, can be used multiple times.
  Each date/time will be passed to the input format parsers in the order they are given, if a date/time can be read successfully with a given input format specifier string, that value will be used.'s minimum occurreces */
  unsigned int input_format_max; /**< @brief Input format, can be used multiple times.
  Each date/time will be passed to the input format parsers in the order they are given, if a date/time can be read successfully with a given input format specifier string, that value will be used.'s maximum occurreces */
  const char *input_format_help; /**< @brief Input format, can be used multiple times.
  Each date/time will be passed to the input format parsers in the order they are given, if a date/time can be read successfully with a given input format specifier string, that value will be used. help description.  */
  const char *backslash_escapes_help; /**< @brief Enable interpretation of backslash escapes in the output and input format specifier strings. help description.  */
  const char *only_matching_help; /**< @brief Show only the part of a line matching DATE. help description.  */
  const char *eq_help; /**< @brief Lines match when date/times are equal to EXPRESSION. help description.  */
  const char *ne_help; /**< @brief Lines match when date/times are not the same as EXPRESSION. help description.  */
  const char *gt_help; /**< @brief Lines match when date/times are newer than EXPRESSION. help description.  */
  const char *lt_help; /**< @brief Lines match when date/times are older than EXPRESSION. help description.  */
  const char *ge_help; /**< @brief Lines match when date/times are newer than or equal EXPRESSION. help description.  */
  const char *le_help; /**< @brief Lines match when date/times are older than or equal EXPRESSION. help description.  */
  const char *nt_help; /**< @brief Lines match when date/times are newer than or equal EXPRESSION. help description.  */
  const char *ot_help; /**< @brief Lines match when date/times are older than or equal EXPRESSION. help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */
  unsigned int input_format_given ;	/**< @brief Whether input-format was given.  */
  unsigned int backslash_escapes_given ;	/**< @brief Whether backslash-escapes was given.  */
  unsigned int only_matching_given ;	/**< @brief Whether only-matching was given.  */
  unsigned int eq_given ;	/**< @brief Whether eq was given.  */
  unsigned int ne_given ;	/**< @brief Whether ne was given.  */
  unsigned int gt_given ;	/**< @brief Whether gt was given.  */
  unsigned int lt_given ;	/**< @brief Whether lt was given.  */
  unsigned int ge_given ;	/**< @brief Whether ge was given.  */
  unsigned int le_given ;	/**< @brief Whether le was given.  */
  unsigned int nt_given ;	/**< @brief Whether nt was given.  */
  unsigned int ot_given ;	/**< @brief Whether ot was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
  int op_group_counter; /**< @brief Counter for group op */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* DGREP_CLO_H */
