# -*- coding: utf-8 -*-
info = {
    "name": "ee",
    "date_order": "MDY",
    "january": [
        "dzove",
        "dzv"
    ],
    "february": [
        "dzodze",
        "dzd"
    ],
    "march": [
        "tedoxe",
        "ted"
    ],
    "april": [
        "afɔfĩe",
        "afɔ"
    ],
    "may": [
        "dama",
        "dam"
    ],
    "june": [
        "masa",
        "mas"
    ],
    "july": [
        "siamlɔm",
        "sia"
    ],
    "august": [
        "deasiamime",
        "dea"
    ],
    "september": [
        "anyɔnyɔ",
        "any"
    ],
    "october": [
        "kele",
        "kel"
    ],
    "november": [
        "adeɛmekpɔxe",
        "ade"
    ],
    "december": [
        "dzome",
        "dzm"
    ],
    "monday": [
        "dzoɖa",
        "dzo"
    ],
    "tuesday": [
        "blaɖa",
        "bla"
    ],
    "wednesday": [
        "kuɖa",
        "kuɖ"
    ],
    "thursday": [
        "yawoɖa",
        "yaw"
    ],
    "friday": [
        "fiɖa",
        "fiɖ"
    ],
    "saturday": [
        "memleɖa",
        "mem"
    ],
    "sunday": [
        "kɔsiɖa",
        "kɔs"
    ],
    "am": [
        "ŋdi"
    ],
    "pm": [
        "ɣetrɔ"
    ],
    "year": [
        "ƒe"
    ],
    "month": [
        "ɣleti"
    ],
    "week": [
        "kɔsiɖa ɖeka"
    ],
    "day": [
        "ŋkeke"
    ],
    "hour": [
        "gaƒoƒo"
    ],
    "minute": [
        "aɖabaƒoƒo"
    ],
    "second": [
        "sekend"
    ],
    "relative-type": {
        "1 year ago": [
            "ƒe si va yi"
        ],
        "0 year ago": [
            "ƒe sia"
        ],
        "in 1 year": [
            "ƒe si gbɔ na"
        ],
        "1 month ago": [
            "ɣleti si va yi"
        ],
        "0 month ago": [
            "ɣleti sia"
        ],
        "in 1 month": [
            "ɣleti si gbɔ na"
        ],
        "1 week ago": [
            "kɔsiɖa si va yi"
        ],
        "0 week ago": [
            "kɔsiɖa sia"
        ],
        "in 1 week": [
            "kɔsiɖa si gbɔ na"
        ],
        "1 day ago": [
            "etsɔ si va yi"
        ],
        "0 day ago": [
            "egbe"
        ],
        "in 1 day": [
            "etsɔ si gbɔna"
        ],
        "0 hour ago": [
            "this hour"
        ],
        "0 minute ago": [
            "this minute"
        ],
        "0 second ago": [
            "fifi"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "le ƒe (\\d+) me",
            "le ƒe (\\d+) si gbɔna me"
        ],
        "\\1 year ago": [
            "ƒe (\\d+) si va yi",
            "ƒe (\\d+) si wo va yi",
            "le ƒe (\\d+) si va yi me",
            "ƒe (\\d+) si va yi me"
        ],
        "in \\1 month": [
            "le ɣleti (\\d+) me",
            "le ɣleti (\\d+) wo me"
        ],
        "\\1 month ago": [
            "ɣleti (\\d+) si va yi",
            "ɣleti (\\d+) si wo va yi"
        ],
        "in \\1 week": [
            "le kɔsiɖa (\\d+) me",
            "le kɔsiɖa (\\d+) wo me"
        ],
        "\\1 week ago": [
            "kɔsiɖa (\\d+) si va yi",
            "kɔsiɖa (\\d+) si wo va yi"
        ],
        "in \\1 day": [
            "le ŋkeke (\\d+) me",
            "le ŋkeke (\\d+) wo me"
        ],
        "\\1 day ago": [
            "ŋkeke (\\d+) si va yi",
            "ŋkeke (\\d+) si wo va yi"
        ],
        "in \\1 hour": [
            "le gaƒoƒo (\\d+) me",
            "le gaƒoƒo (\\d+) wo me"
        ],
        "\\1 hour ago": [
            "gaƒoƒo (\\d+) si va yi",
            "gaƒoƒo (\\d+) si wo va yi"
        ],
        "in \\1 minute": [
            "le aɖabaƒoƒo (\\d+) me",
            "le aɖabaƒoƒo (\\d+) wo me"
        ],
        "\\1 minute ago": [
            "aɖabaƒoƒo (\\d+) si va yi",
            "aɖabaƒoƒo (\\d+) si wo va yi"
        ],
        "in \\1 second": [
            "le sekend (\\d+) me",
            "le sekend (\\d+) wo me"
        ],
        "\\1 second ago": [
            "sekend (\\d+) si va yi",
            "sekend (\\d+) si wo va yi"
        ]
    },
    "locale_specific": {
        "ee-TG": {
            "name": "ee-TG"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}