.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.ny0
.TH XSetCloseDownMode __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetCloseDownMode, XKillClient \- control clients
.SH SYNTAX
.HP
int XSetCloseDownMode\^(\^Display *\fIdisplay\fP\^, int \fIclose_mode\fP\^); 
.HP
int XKillClient\^(\^Display *\fIdisplay\fP\^, XID \fIresource\fP\^); 
.SH ARGUMENTS
.IP \fIclose_mode\fP 1i
Specifies the client close-down mode.
You can pass 
.ZN DestroyAll , 
.ZN RetainPermanent , 
or
.ZN RetainTemporary . 
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIresource\fP 1i
Specifies any resource associated with the client that you want to destroy or
.ZN AllTemporary .
.SH DESCRIPTION
The
.ZN XSetCloseDownMode
defines what will happen to the client's resources at connection close.
A connection starts in
.ZN DestroyAll
mode.
For information on what happens to the client's resources when the
close_mode argument is
.ZN RetainPermanent
or
.ZN RetainTemporary ,
see section 2.6.
.LP
.ZN XSetCloseDownMode
can generate a
.ZN BadValue 
error.
.LP
The
.ZN XKillClient
function
forces a close down of the client
that created the resource
if a valid resource is specified.
If the client has already terminated in
either 
.ZN RetainPermanent 
or 
.ZN RetainTemporary 
mode, all of the client's
resources are destroyed.
If 
.ZN AllTemporary 
is specified, the resources of all clients that have terminated in
.ZN RetainTemporary 
are destroyed (see section 2.5).
This permits implementation of window manager facilities that aid debugging.
A client can set its close-down mode to
.ZN RetainTemporary .
If the client then crashes,
its windows would not be destroyed. 
The programmer can then inspect the application's window tree 
and use the window manager to destroy the zombie windows.
.LP
.ZN XKillClient
can generate a
.ZN BadValue 
error.
.SH DIAGNOSTICS
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
\fI\*(xL\fP
